#include "defs.h"
#include "poly.h"


t_void
poly_str_delete WITH_2_ARGS(
	t_handle,	p,
	t_handle *,	r
)
{
	t_int		i, n;
	t_handle	ring, ring_i, prev;

	ASSERT(block_has_other_refs (*r));

	ring = *r;
	block_decref_delete(*r);
	*r = NH;

	/* if the ring still has other refs, just return */

	if (block_has_other_refs (ring))
		return;

	/* if any ring in the chain has refs, just return */

	ring_i = m_poly_named_ring(ring);
	n = m_poly_nvars(ring);
	for (i = 1; i <= n; i++, ring_i = m_poly_prev_ring(ring_i))
		if (block_has_other_refs(ring_i))
			return;

	/*
	** Delete parent and coefficient ring.
	*/

	ring_biff_cache_blocks(ring);
	ring_i = m_poly_coeff_ring( ring );
	ring_delete(&ring_i );


	ring_i = m_poly_named_ring(ring);
	for (i = 1; i <= n; i++)
	{
		prev = m_poly_prev_ring(ring_i);
		structure_parent_delete( ring_i );
		mem_delete_hptr( &ring_i );
		ring_i = prev;
	}
}
