#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "dyn_arr.h"
#include "bit_vector.h"


static t_int test_d_sets P_((t_int,t_int,t_int*,t_handle,t_handle,integer_big,t_poly*,t_poly,t_bit_vector));

static t_int 
test_d_sets (d,first,last,irred,pring,mint, f,cpoly,degrees)
t_int		d; /* Size of the set */
t_int		first,  *last; 
t_handle	irred,pring;
integer_big	mint; /* modulus */
t_poly 	*f,cpoly;
t_bit_vector	degrees;
{
	t_int		deg;
	t_poly	pfact;
	t_int		i;
	t_poly	fi, fdash;
	t_poly	quot, rem;
	t_poly	ptemp;
	t_int		success;
	integer_big	lcpfact, cpfact, lccpoly, ccpoly, tempa, tempb;
	integer_big	fail;
	block_declarations;

	if (d == 0)
	{
		deg = poly_deg( *f);
		if (! bv_is_set(degrees, deg))
			return 0;
		/* This is where we do the test. */
		pfact = modpoly_symm_rep(pring, mint, *f);
		/* 
		** Optimisation : check to see if lc(pfact)const(pfact) | lc(cpoly)const(cpoly)
		** if not, fail.
		*/
		lcpfact = poly_z_lead_coefft(pring, pfact);
		cpfact = poly_z_const_term(pfact);
		lccpoly = poly_z_lead_coefft(pring, cpoly);
		ccpoly =  poly_z_const_term(cpoly);
		tempa = integer_mult(lccpoly, ccpoly);
		tempb = integer_mult(lcpfact, cpfact);
		if (tempa && !tempb)
			/* 0 is a root of pfact but not of cpoly */
			fail = 1;
		else
			fail = integer_rem(tempa, tempb);

		integer_delref(lcpfact );
		integer_delref(cpfact );
		integer_delref(lccpoly );
		integer_delref(ccpoly );
		integer_delref(tempa );
		integer_delref(tempb );
		if (fail)
		{
			integer_delref(fail );
			poly_z_elt_delete(pring, &pfact);
			return 0;
		}
		poly_z_quot_rem(pring, cpoly, pfact, &quot, &rem);
		if (poly_z_is_zero_poly(pring, rem))
		{
			poly_z_elt_delete(pring, &quot);
			poly_z_elt_delete(pring, &rem);
			poly_z_elt_delete(pring, f);
			*f = pfact;
			return 1;
		}
		else
		{
			poly_z_elt_delete(pring, &pfact);
			poly_z_elt_delete(pring, &quot);
			poly_z_elt_delete(pring, &rem);
			return 0;
		}
	}


	for (i = first;  i <= ((*last) - d + 1) ; i++)
	{
		fi = dyn_arr_element(irred, i);
		fdash = modpoly_mult(pring, mint, *f, fi);
		success = test_d_sets(d-1, first+1, last, irred, pring, mint,  &fdash, cpoly, degrees);
		if (success)
		{
			poly_z_elt_delete(pring, f);
			*f = fdash;
			ptemp = (dyn_arr_element(irred, i));
			(dyn_arr_element(irred, i)) = (dyn_arr_element(irred, *last));
			(dyn_arr_element(irred, *last)) = ptemp;
			(*last)--;	
			return 1;
		}
	}
	return 0;
}


t_handle	poly_u_z_faclst_combine(pring,mint,apoly, irred, degrees)
t_handle	pring;
integer_big 	mint; 
t_poly	apoly; 
t_handle	irred; 
t_bit_vector	degrees;
{
	integer_big	lcb;
	t_poly	bpoly, cpoly;
	t_int		first, last, r;
	t_handle	factors;
	t_poly	f, ptemp, ptemp1;
	t_int		upbnd, d, success;
	integer_big	cont;
	t_poly	primf;
	t_int		knuthop;
	block_declarations;

	/* 
	** Step 1: Initialise
	*/

	bpoly = m_poly_z_incref(pring, apoly);
	first = 0; 
	r = poly_array_length(irred);
	last = r-1; 				/* Last array position */

	factors = poly_array_alloc(r+1);
	/* Worst case : each mod M factor is a Z-factor and 
	** there is a constant multiplier.
	*/
	
	

	/* 
	** Step 2:
	** irred is the list of monic irreducible mod M factors  of apoly and 
	** factors is the array into which we place factors of apoly 
	** over Z. 
	** irred[first] .. irred[last] is the set of mod M factors
	** which we have not yet used to form a factor 
	** of apoly over Z.
	**
	** For each element f of irred, if we cannot find a factor 
	** of apoly, composed of <= r/2 elements of irred, then we
	** increment first. The elements before first are the 
	** mod M factors of the only factor of apoly over Z which is 
	** composed of more than r/2 factors. At the end of the while 
	** loop, the factors before first should be an associate of
	** bpoly.
	**
	** If we do find a factor of apoly containing the mod M factor
	** we are checking, we put the last factor in this position and
	** begin the loop again with first pointing at the same place.
	** We decrease last accordingly. 
	** Since we are now dealing with the problem of finding 
	** factors for bpoly in 0 .. last, we can decrease r by the same
	** amount as we decreased last.
	** In fact we have r = last + 1.
	*/
	lcb = cpoly = 0;
	f = 0;
	
	while (first <= last)
	{
		integer_delref(lcb);
		poly_z_elt_delete(pring, &cpoly);
		lcb = poly_z_lead_coefft(pring, bpoly);
		cpoly = poly_z_integer_mult(pring, bpoly, lcb);

		poly_z_elt_delete(pring, &f);
		ptemp = m_poly_z_incref(pring, dyn_arr_element(irred, first));
		f = modpoly_integer_mult(pring, mint, ptemp, lcb);
		poly_z_elt_delete(pring, &ptemp);
		/* See if lc(u)f1..fd | lc(u)u */

		r = last + 1; /* The number of factors still in cpoly. */
		knuthop = !(r%2);

		upbnd = (r/2 < (last - first+1) ? r/2 : (last - first+1));
		for(d=0; d < upbnd; d++)
		{
			success = test_d_sets(d, first+1, &last,irred,pring, mint, &f, cpoly, degrees);
			/* If successful, f contains lc(u)f1..fd. */
			if (success)
			{
				poly_z_integer_cont_prim_part(pring, f, &cont, &primf);
				integer_delref(cont);
				poly_array_append(factors, primf);
				/* Remember not to delete primf */

				ptemp = bpoly;
				poly_z_quot_rem(pring, ptemp, primf, &bpoly, &ptemp1);
				poly_z_elt_delete(pring, &ptemp);
				poly_z_elt_delete(pring, &ptemp1);

				/* Now swap the last mod M factor with the first. */
				ptemp = dyn_arr_element(irred, first);
				dyn_arr_element(irred, first) = dyn_arr_element(irred, last);
				dyn_arr_element(irred, last) = ptemp;
				/* So the array of irreducibles is the same length,
				** and can be deleted by the caller.
				*/
				last--;
				break;
			}
		}
		/* 
		** We have now decided the factor which contains
		** f, or none do (and d == upbnd)
		*/
		if (d == upbnd)
		{
			if (knuthop)
				break;
			/* 
			** Knuth Optimisation : p.433 Vol 2
			** If 2|r we need only check all the prods of r/2 factors 
			** which contain f1 - if none exist, then bpoly is irreducible.
			*/
			first++;
		}

	}
	poly_z_elt_delete(pring, &cpoly);
	/*
	** Now we have that factors is the array of 
	** factors composed of <= r/2 mod M irreducibles
	** and bpoly is the final factor.
	*/
	
	if (!poly_z_is_one_poly(pring, bpoly))
		poly_array_append(factors, bpoly); /* transfer reference */
	else
		poly_z_elt_delete(pring, &bpoly);
	return factors;
}
