#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "poly_z_faclst.h"
#include "globals.e"


t_void 
poly_u_z_factorize (pring, apoly, sgn, cont, factors)
t_handle	pring;
t_poly	apoly;
t_int 		*sgn;
integer_big 	*cont;
t_handle 	*factors;
/*
** IUPFAC in SAC
** 
** Given univariate apoly, compute sgn - the sign of its leading coefficient,
** cont - the content, and factors, the poly_z_faclst of irreducible factors
** of apoly.
*/
{
	t_poly	bpoly;
	t_poly	prim;
	t_handle	sqfree;
	t_int		i, j, n, m, e;
	t_handle	pfacts;
	t_poly	irred;
	t_poly	polyi;

	/*
	** Step 1: Compute the sign, content and primitive part. 
	*/
	*sgn = poly_z_sign(pring, apoly);
	if (*sgn < 0)
		bpoly = poly_z_negate(pring, apoly);
	else
		bpoly = m_poly_z_incref(pring, apoly);

	poly_z_integer_cont_prim_part(pring, bpoly, cont, &prim);

	/*
	** Step 2: Degree 0 ?
	*/
	if (poly_deg( bpoly) == 0)
	{
		*factors = m_poly_z_faclst_alloc(0);
		return;
	}

	/*
	** Step 3 : Compute squarefree factorisation.
	*/
	sqfree = poly_z_square_free(pring, prim);
	poly_z_elt_delete(pring, &prim);

	/*
	** Step 4 : Factor squarefree factors.
	*/
	n = m_poly_z_faclst_len(sqfree);
	*factors = m_poly_z_faclst_alloc(n);
	for (i = 0; i< n; i++)
	{
		polyi  = m_poly_z_faclst_factor(sqfree, i);
		/* not increffed so don't delete */
		pfacts = poly_u_z_sqfree_fact(pring, polyi);
		m = poly_array_length(pfacts);
		e = m_poly_z_faclst_power(sqfree, i);
		for (j = 0; j < m; j++)
		{
			irred = poly_array_get(pfacts, j);
			poly_z_faclst_add_factor(*factors, pring, irred, e);
		}
		poly_array_delete(pring, &pfacts);
	}
	poly_z_faclst_delete(pring, &sqfree);
	return;
}
			


