#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "zm.e"
#include "error.e"


t_poly
poly_u_zm_nat_rem WITH_4_ARGS(
        t_handle,       pring,
	integer_big,	pdig,
	t_poly,	apoly,
	t_poly,	bpoly
)
/*
** poly_u_zm_nat_rem: modular univariate polynomial natural remainder
** pdig : prime integer.
** apoly: non-zero univariate polynomial over Zpdig .
** bpoly: non-zero univariate polynomial over Zpdig .
** Assume that all coefficients of univariate polys are constants .
** deg( apoly ) >= deg( bpoly ) .
** returns the natural remainder of bpoly .
*/
{
	block_declarations;
	t_int	adeg;
	t_int	bdeg;
	t_int	rdeg;
	t_int	bnterms;
	t_int	rnterms;
	t_poly	respoly;
	t_handle		resph;
	t_poly	bcoefft;
	t_poly	rcoefft;
	t_poly	quotient;
	integer_big	binvert;
	t_handle		bph;
	t_poly	temp;
	t_poly	temp2;
	t_handle		quotph;

	DENY ((m_poly_const (bpoly)) || (m_poly_const (apoly)));

	DENY ( ! m_poly_univariate (m_poly_poly_to_handle (apoly)) || ! m_poly_univariate (m_poly_poly_to_handle (bpoly)));

	DENY ( m_poly_princvar( m_poly_poly_to_handle( apoly )) != m_poly_princvar( m_poly_poly_to_handle( bpoly )));

	bph = m_poly_poly_to_handle( bpoly );
	bnterms = m_poly_nterms( bph );
	bdeg = poly_deg( bpoly );

	adeg = poly_deg( apoly );

	/* Ensure valid input */

	DENY ( adeg < bdeg );

        if (bdeg == 0)
        {
		return poly_z_zero_poly (pring, bpoly);;
	}

	/* deg( bpoly ) > 0, i.e. poly_not_const( bpoly ) */
	/* and poly_not_const( apoly ).				   */

	bcoefft = m_poly_coefft( bph, bnterms - 1 );

	binvert = modint_invert( pdig, bcoefft );

	/* subtract a multiple of bpoly from respoly depending */
	/* on the quotient of the two leading terms			*/

	respoly = m_modpoly_incref( pring, apoly );
	resph = m_poly_poly_to_handle( respoly );
	rnterms = m_poly_nterms( resph );
	rdeg = m_poly_expt( resph, rnterms - 1 );

	do
	{
		rcoefft = m_poly_coefft( resph, rnterms - 1 );
		temp = modint_mult( pdig, rcoefft, binvert );

		/*
		** quotient = temp * var ^ (rdeg - bdeg)
		*/

		m_poly_create_empty(&quotph, m_poly_princvar (resph), m_poly_princvar (resph), 1 );
		quotient = m_poly_handle_to_poly( quotph );

		m_poly_coefft( quotph, 0 ) = temp;
		m_poly_expt( quotph, 0 ) = rdeg - bdeg;

		temp2 = modpoly_mult( pring, pdig, bpoly, quotient );
		m_modpoly_delref( pring, quotient );

		temp = respoly;
		respoly = modpoly_subtract( pring, pdig, temp, temp2 );
		m_modpoly_delref( pring, temp );
		m_modpoly_delref( pring, temp2 );

		/* continue looping till remainder has deg less than bpoly */

		resph = m_poly_poly_to_handle( respoly );
		rnterms = m_poly_nterms( resph );
		rdeg = m_poly_expt (resph, rnterms -1);

	} while ( rdeg >= bdeg );

	integer_delref( binvert );

	return  respoly;
}

