#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "poly_z_faclst.h"
#include "poly_mat.h"
#include "zm.e"
#include "error.e"
#include "debug.e"

t_logical
poly_u_zm_reducible WITH_3_ARGS(
    t_handle,         pring,
    t_int,    pdig,
    t_poly,        apoly
)
/*
** MODUPOLY_REDUCIBLE: Modular univariate polynomial reduciblity test using
** the Berlekamp algorithm. ( MUPFBL ).
**
** pdig: prime beta-integer
** apoly: monic univariate polynomial over Zpdig.
** Returns: TRUE if apoly reducible, FALSE otherwise
*/
{
    block_declarations;
    t_int    adeg;          /* degree of apoly                     */
    t_poly        aderivpoly;    /* derivative of apoly                 */
    t_poly        gcdpoly;       /* gcd at various places               */
    t_handle           Qmatrixh;      /* t_handle for the Q matrix constructed */
    t_handle           vectorsh;      /* t_handle for the matrix of vectors    */
                                    /* in the nullspace                    */
    t_int    i;             /* loop counter                        */

    DENY (m_poly_const (apoly) || ! m_poly_univariate (m_poly_poly_to_handle (apoly)));

    adeg = poly_deg( apoly );

    if ( adeg < 2 )
    {
        /* apoly is irreducible linear, or constant */

        return  FALSE;
    }

    /* Assume that apoly is not const as adeg >= 2 */
    /* Ensure that apoly is square free            */

    aderivpoly = poly_u_zm_deriv( pring, pdig, apoly );
    gcdpoly = poly_u_zm_gcd( pring, pdig, apoly, aderivpoly );
    m_modpoly_delref( pring, aderivpoly );

    if ( ! poly_z_is_one_poly (pring, gcdpoly))
    {
        /* if gcd(apoly,aderivpoly) != 1 then apoly is not sq free */

	m_modpoly_delref( pring, gcdpoly );

        return  TRUE;
    }

    /* apoly is square free */

    m_modpoly_delref( pring, gcdpoly );
    Qmatrixh = poly_u_zm_fact_b2( pring, pdig, apoly );

    /* Set Qmatrix = Qmatrix - I where I is an identity matrix of */
    /* the same dimension as Qmatrix, in preparation for step b3. */

    for ( i = m_poly_mat_row( Qmatrixh ); i >= 1; i-- )
    {
        m_poly_mat_elt( Qmatrixh, i, i ) = modint_subtract( pdig, m_poly_mat_elt( Qmatrixh, i, i ), 1 );
    }
    
    vectorsh = poly_u_zm_fact_b3( pring, pdig, Qmatrixh );

    mem_delete_hptr( &Qmatrixh );

    if ( m_poly_mat_row( vectorsh ) == 1 )
    {
	mem_delete_hptr( &vectorsh );

        /* apoly is irreducible */

        return  FALSE;
    }

    mem_delete_hptr( &vectorsh );

    return  TRUE;
}

