#include "defs.h"
#include "integer.e"
#include "zm.e"
#include "poly.h"
#include "error.e"
#include "debug.e"

t_int
poly_u_zm_resultant WITH_4_ARGS(
        t_handle,       pring,
	t_int,	p,
	t_poly,	apoly,
	t_poly,	bpoly
)
/*
** poly_u_zm_resultant: modular univariate polynomial resultant
** p is a prime.
** apoly, bpoly are univariate polynomials over Zmdig in the same variable
** returns : The resultant mod mdig.
*/
{
	block_declarations;
	t_poly	a1poly;
	t_poly	a2poly;
	t_poly	a3poly;
	t_poly	tpoly;
	t_handle	a2h;
	t_int	n1;
	t_int	n2;
	t_int	n3;
	t_int	c;
	t_int	c2;
	t_int	i;
	t_logical		s;

	IF_DEBUG_FLAG(DEBUG_POLY,
	{
		t_handle ah;
		t_handle bh;

		if ( m_poly_const (apoly) || m_poly_const (bpoly))
		{
			error_internal( "expecting univariate polynomials in modupoyl_resultant" );
		}

		ah = m_poly_poly_to_handle (apoly);
		bh = m_poly_poly_to_handle (bpoly);

		if ( ! m_poly_univariate( ah ) || ! m_poly_univariate( bh ))
		{
			error_internal( "expecting univariate polynomials in modupoyl_resultant" );
		}

		if (m_poly_princvar(ah) != m_poly_princvar(bh))
		{
			error_internal( "different princvar for univariate polys" );
		}
	}
	)

    if (poly_z_is_zero_poly (pring, apoly))
    {
        if (poly_z_is_zero_poly (pring, bpoly))
            return 0;
        if (poly_deg( bpoly) == 0)
            return 1;
        return 0;
    }
    if (poly_z_is_zero_poly (pring, bpoly))
    {
        if (poly_z_is_zero_poly (pring, apoly))
            return 0;
        if (poly_deg( apoly) == 0)
            return 1;
        return 0;
    }
    if (poly_deg( apoly) == 0)
    {
        return (integer_power (m_poly_coefft (m_poly_poly_to_handle (apoly),0), poly_deg( bpoly)));
    }
    if (poly_deg( bpoly) == 0)
    {
        return (integer_power (m_poly_coefft (m_poly_poly_to_handle (bpoly),0), poly_deg( apoly)));
    }

	/* Initialize */
	c = 1;
	a1poly = m_modpoly_incref (pring, apoly);
	a2poly = m_modpoly_incref (pring, bpoly);
	n1 = poly_deg( a1poly);
	n2 = poly_deg( a2poly);
	s = FALSE;
	if (n1 < n2)
	{
		if ((n1&1) && (n2&1))
			s = TRUE;
		tpoly = a1poly;
		a1poly = a2poly;
		a2poly = tpoly;
	}
	do
	{
		a3poly =  poly_u_zm_nat_rem (pring, p, a1poly, a2poly);
		if (poly_z_is_zero_poly (pring, a3poly))
		{
			c = 0;
			m_modpoly_delref (pring, a3poly);
			goto Done;
		}
		n1 = poly_deg( a1poly);
		n2 = poly_deg( a2poly);
		n3 = poly_deg( a3poly);
		if ((n1&1) && (n2&1))
			s = !s;
		a2h = m_poly_poly_to_handle( a2poly);
		c2 = m_poly_coefft(a2h, m_poly_nterms(a2h) - 1);
		for(i=1;i<=n1-n3;i++)
			c = modint_mult (p, c, c2);
		m_modpoly_delref (pring, a1poly);
		a1poly = a2poly;
		a2poly = a3poly;
	} while (n3);
		
	a2h = m_poly_poly_to_handle( a2poly);
	c2 = m_poly_coefft(a2h, m_poly_nterms(a2h) - 1);
	for (i=1;i<=n2;i++)
	{
		c = modint_mult(p, c, c2);
	}
	if (s)
		c = p - c;
Done:
	m_modpoly_delref (pring, a1poly);
	m_modpoly_delref (pring, a2poly);
	return (c);
}

