#include "defs.h"
#include "integer.e"
#include "poly.h"

t_poly
poly_z_abs WITH_2_ARGS(
    t_handle,    pring,
    t_poly,   apoly
)
/*
*   IPOLY_ABS : if leading coefft of apoly is >= 0 
*                        returns apoly
*                if leading coefft of apoly is negative
*                        returns negate of apoly
*/
{
    if ( poly_z_sign( pring, apoly ) >= 0 )
    {
        /* leading coefft positive or zero */
        return  m_poly_z_incref( pring, apoly );
    }
    else
    {
        /* leading coefft negative */
        return  poly_z_negate( pring, apoly );
    }
}

