#include "defs.h"
#include "integer.e"
#include "poly.h"

t_poly
poly_z_add WITH_3_ARGS(
    t_handle,    pring,
    t_poly,   apoly,
    t_poly,   bpoly
)
/*
*    IPOLY_ADD: integral polynomial sum. apoly, bpoly  integral
*    polynomials, poly_z_add returns their sum as an integral polynomial
*/
{
    t_handle           resph;        /* t_handle to respoly          */
    t_handle           aph;          /* t_handle to apoly            */
    t_handle           bph;          /* t_handle to bpoly            */
    t_int    anterms;      /* no. terms in apoly         */
    t_int    bnterms;      /* no. terms in bpoly         */
    t_int    resnterms;    /* max. no. terms in respoly  */
    t_int    restermno;    /* term counter for respoly   */
    t_int    atermno;      /* term counter for apoly     */
    t_int    btermno;      /* term counter for bpoly     */
    t_poly        acoefft;      /* coefficient variables      */
    t_poly        bcoefft;
    t_int    aexpt;        /* exponent variables         */
    t_int    bexpt;
    t_poly        temp;         /* swaps                      */

    if (m_poly_const (apoly))
    {
        return integer_add (apoly, bpoly);
    }
    aph = m_poly_poly_to_handle( apoly );
    bph = m_poly_poly_to_handle( bpoly );

    anterms = m_poly_nterms( aph );
    bnterms = m_poly_nterms( bph );
    resnterms = anterms + bnterms;

    atermno = btermno = restermno = 0;
    m_poly_create_empty(&resph, m_poly_princvar( aph ),
                                 m_poly_least_pvar( aph ), resnterms );

    while ( ( atermno < anterms ) && ( btermno < bnterms ) ) 
    {
        aexpt = m_poly_expt( aph, atermno );
        bexpt = m_poly_expt( bph, btermno );

        if ( aexpt < bexpt )
        {
            poly_z_copy_term( pring, &resph, restermno, aph, atermno );
            restermno++;
            atermno++;
        }
        else if ( aexpt > bexpt )
        {
            poly_z_copy_term( pring, &resph, restermno, bph, btermno );
            restermno++;
            btermno++;
        }
        else
        {
            /* aexpt == bexpt */

            acoefft = m_poly_coefft( aph, atermno );
            bcoefft = m_poly_coefft( bph, btermno );

            if ( m_poly_univariate( aph ))
            {
                temp = integer_add( acoefft, bcoefft );
            }
            else
            {
                temp = poly_z_add( pring, acoefft, bcoefft );
            }

            m_poly_coefft( resph, restermno ) = temp;
            m_poly_expt( resph, restermno ) = aexpt;
            restermno++;
            atermno++;
            btermno++;
        }
    }

    /* copy rest of apoly */

    for ( ; atermno < anterms; atermno++, restermno++ )
    {
        poly_z_copy_term( pring, &resph, restermno, aph, atermno );
    }

    /* copy rest of bpoly */

    for ( ;btermno < bnterms; btermno++, restermno++ )
    {
        poly_z_copy_term( pring, &resph, restermno, bph, btermno );
    }

    m_poly_nterms( resph ) = restermno;
    return  poly_z_clean (pring, m_poly_handle_to_poly( resph )); 

} /* poly_z_add() */



#if 0
t_poly
poly_z_integer_add WITH_2_ARGS(
    t_poly,      apoly,
    integer_big,    acoefft
)
/*
*    IPOLY_INTEGER_ADD: Adds an constant to a polynomial
*     apoly is an integral poly, acoefft a constant
*     ipoly-integer_add returns poly = apoly + acoefft
*/
{
    trbl_declarations;
    t_handle           resph;      /* t_handle to respoly  */
    t_handle           aph;        /* t_handle to apoly    */
    t_int    nterms;     /* no. terms in apoly */
    t_int    atermno;    /* loop counter       */
    t_poly       temp;

    if ( acoefft == 0 )
    {
        /* no addition required */
        return  poly_z_incref( apoly );
    }

    if ( apoly == 0 )
    {
        /* zero poly, result is constant itself */
        return  integer_incref( acoefft );
    }

    if ( m_poly_const( apoly ) )
    {
        /* apoly and aint both constant */
        return  integer_add( apoly, acoefft );
    }

    /* general case: non-trivial polys */

    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph );

    if ( nterms == 0 )
    {
    return  integer_incref( acoefft );
    }

    if ( m_poly_expt( aph, 0 ) == 0 )
    {
        /* constant term exists, add to it & copy remaining terms */

        temp = poly_z_integer_add( m_poly_coefft( aph, 0 ), acoefft );
    if ( temp != 0 )
    {
            poly_init_poly( &resph, INTBIG_TRBL_TYPE, 0,
                m_poly_princvar( aph ), nterms );

        m_poly_coefft( resph, 0 ) = temp;
        m_poly_expt( resph, 0 ) = 0;

        /* copy remaining terms */

            for ( atermno=1; atermno<nterms; ++atermno )
            {
            poly_z_copy_term( &resph, atermno, aph, atermno );
            }

        m_poly_nterms( resph ) = nterms;
    }
    else
    {
        if ( nterms == 1 )
        {
        return  0;
        }

            /* copy terms other than first */

            poly_init_poly( &resph, INTBIG_TRBL_TYPE, 0,
                m_poly_princvar( aph ), nterms - 1 );

            for ( atermno=1; atermno<nterms; ++atermno )
            {
            poly_z_copy_term( &resph, atermno - 1, aph, atermno );
            }

        m_poly_nterms( resph ) = nterms - 1;
    }

        return  poly_z_clean( m_poly_handle_to_poly( resph ) );
    }

    /* no constant term */
    /* insert acoefft */

    poly_init_poly( &resph, INTBIG_TRBL_TYPE, 0,
                 m_poly_princvar( aph ), nterms + 1 );

    m_poly_expt( resph, 0 ) = 0;
    m_poly_coefft( resph, 0 ) = integer_incref( acoefft );

    /* copy remaining terms */

    for ( atermno=0; atermno<nterms; ++atermno )
    {
        poly_z_copy_term( &resph, atermno + 1, aph, atermno );
    }

    m_poly_nterms( resph ) = nterms+1;
    return  m_poly_handle_to_poly( resph );

} /* poly_z_integer_add() */
#endif

