
#include "defs.h"
#include "poly.h"

t_handle 
poly_z_discriminant(pring, apoly)
t_handle	pring;
t_poly	apoly;
/* See Knuth vol2 p.619 for the formula. */
{
	block_declarations;
	integer_big	leada;
	t_int		deg, sign, expon;
	t_poly	apoly_dash, resultant, temp;
	t_poly	discriminant;
	


	/* Determine sign  of the discriminant. */
	deg = poly_deg( apoly);
	expon = deg*(deg - 1)/2;
	sign = expon & 1 ? -1 : 1;

	/* Determine the leading coefft. */
	leada = poly_lbase_coefft(pring, apoly);

	/* Determine the res(apoly, apoly') */
	apoly_dash = poly_z_deriv_princvar(pring, apoly);
	resultant = poly_z_resultant_top(pring, apoly, apoly_dash);
	poly_z_elt_delete(pring, &apoly_dash);

	/* Put it all together */
	temp = poly_z_integer_div(pring, resultant, leada);
	poly_z_elt_delete(pring, &resultant);
	integer_delref(leada);
	discriminant = poly_z_integer_mult(pring, temp, sign);
	poly_z_elt_delete(pring, &temp);

	return discriminant;
}


