#include "poly.h"
#ifndef KANT
#include "bind.h"
#endif
#include "ring.e"

t_logical
poly_z_elt_coerce WITH_6_ARGS (
        t_handle,       polyring,
        t_handle,       str,
        t_handle,       elt,
        t_int,          itm,
        t_handle *,     nelt,
        t_int *,        nitm
)
/*
** Lift elt into polyring
*/
{
	t_handle temp;
	t_int	i, lst_var;

	ASSERT (structure_repnum(polyring) == REP_POLY_Z);

#ifndef KANT
    if (structure_varnum(str) != VAR_RING)
        return FALSE;
#endif 
    switch (ring_type (str))
    {
    case RING_POLY :
		if (m_poly_named_ring (polyring) != m_poly_named_ring (str))
            return FALSE;
		if (m_poly_nvars(polyring) < m_poly_nvars(str))
			error_internal ("poly_z_elt_coerce: can't restrict yet");
        *nelt = m_poly_z_incref (polyring, elt);
		lst_var = m_poly_first_var (str) + m_poly_nvars(str) - 1;
		for (i = m_poly_first_var(str) - 1; i >= m_poly_first_var(polyring); i--)
		{
			m_poly_create_empty(&temp, i, lst_var, 1);
			m_poly_coefft(temp, 0) = *nelt;
			m_poly_expt(temp, 0) = 0;
			*nelt = m_poly_handle_to_poly(temp);
		}
        break;
    case RING_Z :
        lst_var = m_poly_first_var (polyring) + m_poly_nvars(polyring) - 1;
        *nelt = poly_z_constant_dims (polyring, m_poly_first_var(polyring), lst_var, elt);
        break;
    default :
        return FALSE;
    }
    *nitm = 0;
    return TRUE;
}

