
#include "defs.h"
#include "integer.e"
#include "poly.h"

integer_big
poly_z_max_norm WITH_2_ARGS(
    t_handle,    pring,
    t_poly,   apoly
)
/*
*    IPOLY_MAX_NORM : integral polynomial maximum norm .
*    apoly is an integral polynomial .
*    returns the maximum norm of apoly, |apoly|sub infinity
*/
{
    block_declarations;
    integer_big       resint;        /*    progressive max norm  */
    t_handle            aph;           /*    t_handle to apoly       */
    t_poly         coefft;        /*    coefficient variable  */
    t_int     nterms;        /*    no. of terms          */
    integer_big       bint;          /*    intermediate max norm */
    t_int     i;             /*    loop counter          */

    if ( m_poly_const( apoly ) )
    {
        /* apoly constant, max. norm of constant is absolute value */
        return  integer_abs( apoly );
    }

    /* apoly a non-trivial polynomial */

    resint = 0;
    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph );

    /* progressively find max. norms for each coefficient of */
    /* apoly and compare with previous maximum.  */

    if (m_poly_univariate (aph))
    {
        for ( i = 0; i < nterms; i++ )
        {
            coefft = m_poly_coefft( aph, i );
            bint = integer_abs( coefft );
	    if ( integer_compare( resint, bint ) < 0 )
	    {
	        integer_delref( resint );
	        resint = bint;
	    }
	    else
	        integer_delref( bint );
        }
    }
    else
    {
        for ( i = 0; i < nterms; i++ )
        {
            coefft = m_poly_coefft( aph, i );
            bint = poly_z_max_norm( pring, coefft );
	    if ( integer_compare( resint, bint ) < 0 )
	    {
	        integer_delref( resint );
	        resint = bint;
	    }
	    else
	        integer_delref( bint );
        }
    }

    return  resint;

} /* poly_z_max_norm() */



integer_big
poly_z_sum_norm WITH_2_ARGS(
    t_handle,    pring,
    t_poly,   apoly
)
/*
*    IPOLY_SUM_NORM : integral polynomial sum norm.
*    apoly is an integral polynomial in several variables.
*    returns the sum norm of apoly 
*/
{
    block_declarations;
    integer_big      bint;           /* progressive sum norm  */
    integer_big      cint;           /* intermediate sum norm */
    t_poly        acoefft;        /* coefficient variable  */
    t_handle           aph;            /* t_handle to apoly       */
    t_int    i;              /* loop counter          */
    t_int    nterms;         /* no. of terms in apoly */
    integer_big      temp;

    if ( m_poly_const( apoly ) )
    {
        /* apoly constant, norm of constant is absolute value */
        return  integer_abs( apoly );
    }

    /* apoly non-constant */

    bint = 0;
    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph );

    /* find norm of each term of apoly and progressively sum up */

    if ( m_poly_univariate (aph))
    {
        for ( i = 0; i < nterms; i++ )
        {
            acoefft = m_poly_coefft( aph, i );
            cint = integer_abs( acoefft );
	    temp = bint;
            bint = integer_add( temp, cint );
	    integer_delref( temp );
	    integer_delref( cint );
        }
    }
    else
    {
        for ( i = 0; i < nterms; i++ )
        {
            acoefft = m_poly_coefft( aph, i );
            cint = poly_z_sum_norm( pring, acoefft );
	    temp = bint;
            bint = integer_add( temp, cint );
	    integer_delref( temp );
	    integer_delref( cint );
        }
    }

    return  bint;

} /* poly_z_sum_norm() */

