#ifndef KANT
#include "bind.h"
#endif


#include "poly.h"
#include "zm.e"
#include "ring.e"

t_logical
poly_zm_elt_coerce (polyring, str, elt, itm, nelt, nitm)
t_handle       polyring;
t_handle       str;
t_handle       elt;
t_int          itm;
t_handle 	*nelt;
t_int 		*nitm;
/*
** Lift elt into polyring
*/
{
    block_declarations;
    t_handle temp;
    t_int    i, lst_var;

	ASSERT (structure_repnum (polyring) == REP_POLY_ZM);

#ifndef KANT
    if (structure_varnum(str) != VAR_RING)
        return FALSE;
#endif

    switch (ring_type (str))
    {
    case RING_POLY :
        if (m_poly_named_ring (polyring) != m_poly_named_ring (str))
            return FALSE;
        if (m_poly_nvars(polyring) < m_poly_nvars(str))
            error_internal ("poly_zm_elt_coerce: can't restrict yet");
        *nelt = m_poly_z_incref (polyring, elt);
        lst_var = m_poly_first_var (str) + m_poly_nvars(str) - 1;
        for (i = m_poly_first_var(str) - 1; i >= m_poly_first_var(polyring); i--)
        {
            m_poly_create_empty(&temp, i, lst_var, 1);
            m_poly_coefft(temp, 0) = *nelt;
            m_poly_expt(temp, 0) = 0;
            *nelt = m_poly_handle_to_poly(temp);
        }
        break;
    case RING_Z :
        elt = modint_hom (zm_modulus(m_poly_coeff_ring(polyring)), elt);
        *nelt = poly_z_constant_dims (polyring, 1,
                                    m_poly_nvars(polyring), elt);
        integer_delref (elt);
        break;
    case RING_ZM :
        if (!ring_str_equal (m_poly_coeff_ring(polyring), str))
            return FALSE;
        *nelt = poly_z_constant_dims (polyring, 1,
                                    m_poly_nvars(polyring), elt);
        break;
    default :
        return FALSE;
    }

#ifndef KANT
    *nitm = EVAL_NO_ITEM;
#else
    *nitm = 0;
#endif
    return TRUE;
}

