/*
 *	Glue between principal_ideal and bind.
 */

#include "defs.h"
#include "error.e"
#include "principal_ideal.e"


public t_handle
glue_principal_ideal_add(s1, e1, e2, res_e)
t_handle s1, e1, e2, *res_e;
{
    *res_e = principal_ideal_elt_add(s1, e1, e2);
    return NH;
}

public t_handle
glue_principal_ideal_subtract(s1, e1, e2, res_e)
t_handle s1, e1, e2, *res_e;
{
    *res_e = principal_ideal_elt_subtract(s1, e1, e2);
    return NH;
}

public t_handle
glue_principal_ideal_negate(s, e, res_e)
t_handle s, e, *res_e;
{
    *res_e = principal_ideal_elt_negate(s, e);
    return NH;
}

public t_handle
glue_principal_ideal_mult(str, e1, it1, e2, it2, res_e, res_it)
t_handle str, e1, it1, e2, it2, *res_e, *res_it;
{
    *res_e = principal_ideal_elt_mult(str, e1, e2);
    *res_it = 0;
    return NH;
}

public t_handle
glue_principal_ideal_power(s1, e1, it1, n, res_s, res_e, res_it)
t_handle s1, e1, it1, n, *res_s, *res_e, *res_it;
{
    *res_e = principal_ideal_elt_power(s1, e1, n);
    *res_s = ideal_incref(s1);
    *res_it = 0;
    return NH;
}

public t_handle
glue_principal_ideal_eq(s1, e1, it1, s2, e2, it2)
t_handle s1, e1, it1, s2, e2, it2;
{
    return principal_ideal_elt_equal(s1, e1, e2);
}

public t_handle
glue_principal_ideal_str_add(s1, e1, e2, res_e)
t_handle s1, e1, e2, *res_e;
{
	*res_e = principal_ideal_str_add(e1, e2);
	return NH;
}

public t_handle
glue_principal_ideal_str_mult(str, e1, it1, e2, it2, res_e, res_it)
t_handle str, e1, it1, e2, it2, *res_e, *res_it;
{
	*res_e = principal_ideal_str_mult(e1, e2);
	*res_it = 0;
	return NH;
}

public t_handle
glue_principal_ideal_str_meet(s1,s2)
t_handle s1,s2;
{
	return principal_ideal_str_meet(s1, s2);
}

public t_handle
glue_principal_ideal_str_div(s, a, b)
t_handle s, a, b;
{
	return principal_ideal_str_div(a, b);
}

public t_handle
glue_principal_ideal_str_eq(s1, e1, it1, s2, e2, it2)
t_handle s1, e1, it1, s2, e2, it2;
{
	if (s1 !=s2)
		return FALSE;
	return principal_ideal_str_equal(e1, e2);
}

public t_handle
glue_principal_ideal_scalar_mult(str, elt, coef, res_e)
t_handle str, elt, coef, *res_e;
{
	*res_e = principal_ideal_elt_scalar_mult(str, elt, coef);
	return NH;
}

public t_handle
glue_principal_ideal_str_scalar_mult(str, elt, coef, res_e)
t_handle str, elt, coef, *res_e;
{
	*res_e = principal_ideal_str_scalar_mult(elt, coef);
    return NH;
}

public t_handle
glue_principal_ideal_is_member(s1, s2, e2, it2)
t_handle s1, s2, e2, it2;
{
	return principal_ideal_is_member(s1, s2, e2);
}

public t_handle
glue_principal_ideal_is_subsetq(s1, s2)
t_handle s1, s2;
{
	return principal_ideal_is_subideal(s1, s2);
}
