#include "kant.h"



t_logical 
anf_elt_is_square_rem WITH_4_ARGS (order      , ord   ,
                                   anf_ideal  , ideal ,
		    	           anf_elt    , alpha ,
                                   anf_elt*   , my     )
/*******************************************************************************
 
Description:
 
      Checks if alpha is a sqaure-remainder of the ideal ideal.
      (i.e. there ex. an my in the maximal order ord such that  :
                alpha  congr. my^2 mod. ideal                              )

     In Case such an my ex. the function will return TRUE an my stored
     in the variable my.
 
Calling sequence:
 
 
      	order  	      ord           : Maximal order of a field.
        anf_ideal     ideal         : the congr. ideal.
        anf_elt       alpha         : the remainder for the quadratic congr.

        anf_elt       my            : In case the function returns TRUE
                                      my saticefies :
                                             alpha - my^2 in ideal.

       t_logical      is_square_rem : the return-value of the function.


          is_square_rem = anf_elt_is_square_rem (ord,ideal,alpha,&my);

History:                                          
 
	92-09-07 MD     written
 
*******************************************************************************/

{
     
         block_declarations;


         anf_elt     a,beta,gamma,temp;
     
         t_logical     sqr_rem_found,ok;
        
  *my  = MEM_NH;                                                

  temp           = anf_negate (ord,alpha);
  sqr_rem_found  = FALSE;
   
  anf_ideal_remainder_init (&a);

  while (    (ok = anf_ideal_remainder_half_next (ord,ideal,&a))
          && (!sqr_rem_found)                                    )
  {
    beta  = anf_elt_mult (ord,a,a);
    gamma = anf_elt_add (ord,temp,beta);

    if (sqr_rem_found = anf_elt_in_ideal (ord,gamma,ideal)) 
      *my = anf_elt_incref (a);
                       
    if (anf_print_level > 5)
    {
      printf (" a = ");anf_elt_write (ord,a); printf ("   a^2 = ");anf_elt_write (ord,beta);
      if (sqr_rem_found)
        printf ("  and (alpha - a^2) is IN ideal\n");      
      else
        printf ("  and (alpha - a^2) is NOT IN ideal\n");      
    }  

    anf_elt_delete (ord,&beta);
    anf_elt_delete (ord,&gamma);
  }


  anf_elt_delete (ord,&temp);   
  anf_elt_delete (ord,&a);
                      

  return sqr_rem_found;
}




