/*******************************************************************************
  test_for_square_factors.c 
********************************************************************************/


#include <stdio.h>             
#include "kant.h"

anf_elt
test_for_square_factors WITH_2_ARGS (order,          ord,
                                     anf_elt,        alpha)
/*******************************************************************************

Description:
  
                                                                                            
Calling sequence:       
                                                                  
         order          start_order   :  The p-max. overorder will be computed 
                                         relaive to this order.   

History:
                                
      MD 92-06-  first version                                       					

********************************************************************************/
{         
    t_logical       is_factored;
    matrix        rel_mat;
    faclst        fac;
 
    vector        exp;
    
    integer_small n,i,pos_alpha;
  
/* First factorise the alg. number */          

  if (!anf_elt_factorize (ord,alpha))
    error_internal ("TEST_FOR_SQUARE_FACTORS : Can't factorise alg. number");

/* OK we are able to factorise alpha */
                            

   pos_alpha = order_relation_count (ord);  /* The last entry is alpha         */
                                            /* Maybe there are already some    */
                                            /* relations                       */
   rel_mat = order_relation_mat (ord);                  
        
 
   n = order_fac_basis_ideals_count (ord);        
   exp = vec_new (n);
                     
   for (i=1;i<=n;i++)
   {
     vec_elt (exp,i) = (integer_is_even (mat_elt (rel_mat,i,pos_alpha)) ? 0 : 1);
     printf (" (%d) %d <-- %d \n",i,vec_elt (exp,i),mat_elt (rel_mat,i,pos_alpha));
   }
                                    
   return anf_elt_incref (alpha);

              
}
