#include "kant.h" 
#include "rel_lattice.h" 
#include "anf_rel_sort.h" 



t_void
rel_order_fincke_find_gamma_prod WITH_5_ARGS( 
	order,		sub_ord,
	vector,         K,
	vector *,       gamma,
	vector *,       lambdas,
        anf_rel_sort,   sort
)
/*******************************************************************************
 
Description:
 
	The function finds the optimal gamma values for the relative
        norm equations.

 
Calling sequence:
 
	rel_order_fincke_find_gamma_opt(ord, K, &gamma, sort);
 
      	order  	        sub_ord  = t_handle of the suborder 
      	vector          K        = the absolute relative norm
      	vector          gamma    = the optimal gamma's       
        anf_rel_sort    sort     = the sorting of the conjugates
 
History:
 
	93-01-06 AJ    written
 
*******************************************************************************/
{  
	block_declarations;

	integer_small	i, j, n, cnt, r1r2, m, h1;
        t_real          ubound, step, temp1, minh, min, one, h, p1, p2;
        t_real          temp2, temp3, g;
	t_handle	R;
        vector		lambda, lambda_store;    
        double          la;
	char		str[200];
        

          
/*** Initialisation  **********************************************************/

	n= order_abs_degree(sub_ord); 
        m= anf_rel_sort_m(sort);
	r1r2= order_r1(sub_ord)+order_r2(sub_ord);
	R= order_reals(sub_ord); 

        one = conv_double_to_real (R,1.0);   
        ubound= conv_int_to_real(R, 10);           
        step= conv_double_to_real(R, 1.0);           
                              
/*** Loop of some lambdas            ******************************************/

	i= 1;                        
        lambda= vec_new(r1r2);
        *gamma= vec_new(r1r2);
        for (j= 1; j<=r1r2; j++)
	  vec_entry(lambda,j)= conv_double_to_real(R, 1.1);
          
         do
	 {     
          for (j= 1; j<=r1r2; j++)
           {   
            /* the function g(t)^(m/2)  */ 

            h= H (R,vec_entry(lambda,j),one);
            temp1 = real_subtract (R,one,h);    
            temp2 = real_real_power (R,vec_entry(lambda,j),h);
            temp3 = real_divide  (R,temp2,vec_entry(lambda,j));
            p1 = real_mult (R,temp1,temp2);
            real_delete (&temp1);
            real_delete (&temp2); 
            p2 = real_mult (R,h,temp3);
            real_delete (&temp3);
            real_delete (&h);

            g = real_add (R,p1,p2);

            real_delete (&p1);
            real_delete (&p2);
        
            temp1= real_power (R,g,m);
            temp2= real_sqrt(R, temp1);
            temp3= real_mult(R, vec_entry(K,j), temp2);

            vec_entry(*gamma,j)= real_subtract(R, temp3,vec_entry(K,j));

            real_delete (&temp1);
            real_delete (&temp2); 
            real_delete (&temp3);
            real_delete (&g); 
            
           }                      
          
          min= rel_order_fincke_min_fkt (R,lambda, K, sort);       

          if (anf_print_level>=0)
           {
            printf("\nLambda's: ");
            mat_real_write_aj(R, lambda, 15); 
            printf("\nGamma's: ");
            mat_real_write_aj(R, *gamma, 15); 
            printf("\nmin: ");
            real_write_aj(R, min, 15);
            printf("\n");
           }

 	   temp1= vec_entry(lambda,i);
           vec_entry(lambda,i)= real_add(R, temp1,step);
 	   real_delete(&temp1);

           if ( real_compare(R, vec_entry(lambda,i), ubound)<= 0 )
            {
             i= 1;  
            }
           else
            {
 	     temp1= vec_entry(lambda,i);
             vec_entry(lambda,i)= conv_double_to_real(R, 1.1);
 	     real_delete(&temp1); 

	     i= i+1;
 	    }

         }
        while (i<=r1r2);



/*** end  *********************************************************************/

        real_delete (&one);
        real_delete (&ubound);
        real_delete (&step);

	return;

}    
    


main()  
/*******************************************************************************
 
AJ Januar 1992
Last modification: -.

 
 
 
Description:
 
	Creates gamma and lambda values
	
        Input format

         1)  Field 1 
         2)  Subfield
         3)  Which routines are called (0= both, 1= rel.., 2= abs....)
         4)  |N()| or N()  (0,1)
         4)  One solution or all solutions  (0,1)
         5)  Algebraic integer in the subfield for the relativ norm
         6)  If gammas are read or not (1,0)
         7)  r_1+r_2  Gamma values if in 5) 1 is read
        
        
	 
	Planned: -.

 
Calling sequence:
 
	-
 
History:
 
	92-06-2 AJ    written
 
*******************************************************************************/
{
	block_declarations;         
         
  	int			i,j, n, l, k, nm, m, int1, sj, tj; 
	int			sub_r1, sub_r2, sub_r1r2, subr, read_G, preci;
	t_logical		ok, abs_value, find_all;

	char			str[200];

   	t_handle          	R, Z, C;  
	order			ord, sub_ord, rel_ord, ord_h2;   
        anf_elt         	a_elt, a_elt_con, beta_elt, beta_elt_con; 

	t_real			t2_norm, h1, h2, h3, zero, loceps;  
	vector			rel_basis, rel_con;

	anf_rel_sort		sort;

	matrix			mat_h1;

	rel_lattice     	rel_lat;               
        rel_lat_enum_env	rel_env;            
	t_comp			comp_h1, comp, ctemp1, ctemp2, ctemp3, ctemp4, ctemp5;
	int 			lat_flag;

	lattice     	lat;               
        lat_enum_env	env;    

        /*  definitions for the moving of elements  */

	anf_elt			elt_h1, elt_h2, elt_h3, rel_elt, ord_elt, elt_h4, norm_elt;
	matrix			trans_pow_ord, trans_pow_sub_ord;
	matrix			trans_sub_ord_ord, trans_rel_ord;
	matrix			trans_ord_rel;
	matrix			mat_h2, mat_h3, mat_h4, mat_h5;
	integer_big 		det, trans_ord_rel_den, denom, abs_norm, abs_den;
	integer_big 		det_rel, prod_k;
	integer_small		erg, lauf1, lauf2, lauf3, lauf4, flag;
	vector			norms;
	dyn_arr_handle		store1, store2;

        /*  definitions for norm equations  */

	vector			K, G, dum1, dum2;
        dyn_arr_handle	        sol_list, normal_list;

/*** Initialisation  **********************************************************/
                                        
        preci= 30;

	kant_start();
	printf("\nfin.x ...... \n\n");

/*** Input loop  **************************************************************/
 
	while ( order_read(&ord) && order_read(&sub_ord) ) 
	{   
          /*** Initialisation of the orders  ***/
             
		order_reals_set(ord, preci);
		order_reals_create(ord);
		order_mult_table_create(ord); 
		nm=  order_abs_degree(ord);  

                R = order_reals(ord);            
		zero= conv_int_to_real(R,0); 
                loceps= real_make(R, 10, -real_dec_prec(R)+2 );  
		C = comp_create(real_dec_prec(R));
	        Z= m_z_str_incref(structure_z);

		order_reals_set(sub_ord, preci);
		order_reals_create(sub_ord);      

		ord_h2= order_lll_reduce(sub_ord);
                order_delete(&sub_ord); 
	        sub_ord= order_incref(ord_h2);
                order_delete(&ord_h2);        

		order_reals_set(sub_ord, preci);
		order_reals_create(sub_ord);
		order_mult_table_create(sub_ord);
		n=  order_abs_degree(sub_ord);
		sub_r1=  order_r1(sub_ord);
		sub_r2=  order_r2(sub_ord);
		sub_r1r2=  sub_r1+sub_r2;

		if (nm%n) 
		 {
		  printf("\n\nThe second field is not a subfield!\n\n");
		  printf(  "Terminated.\n\n");  

		  goto end;
		 }      
                                      
          /*** Construct a relative  basis  ***/

		m= nm/n;
		rel_basis= vec_new(m);  

		elt_h1= order_primitive_elt(ord);
	        for (i=1; i<=m; i++)      
	          vec_entry(rel_basis,i)= anf_power(ord, elt_h1, i-1);
	        anf_elt_delete(ord, &elt_h1);

                if (anf_print_level>=2)
                 {
                  printf("\nRelative Basis in reference to the integral basis:\n");
	          for (i=1; i<=m; i++)      
                   {
	             anf_elt_write(ord, vec_entry(rel_basis,i) );
                     printf("\n");
                   }
                 }
	

	


          /*** Shortest primitive element   ***/

		beta_elt= order_shortest_primitive_elt(sub_ord);  

                /*** Output of beta_elt           ***/

                beta_elt_con= anf_elt_con(sub_ord, beta_elt);  
               
		if (anf_print_level >=2 )
		 {
		  printf("The conjugates of a shortest primitive");
	  	  printf(" element in the sub_order:\n\n");
                  anf_elt_write(sub_ord,beta_elt); printf("  =  \n");
                  anf_elt_write(sub_ord,beta_elt_con); printf("\n\n");
		 }

                /*** Output of the T_2-norm of beta_elt              ***/

		t2_norm= anf_elt_t2(sub_ord, beta_elt);

		if (anf_print_level >=2 )
		 {
                  printf("T_2-norm of this element:                 "); 		 
                  real_write(R, t2_norm, 20); printf("\n\n\n\n\n\n");
		 }


          /*** Find the representation of beta_elt_con in the integral  ***/
          /*** basis of ord                                             ***/


		if (anf_elt_embed_aj(sub_ord, beta_elt, 0, ord, &a_elt))
 		 {
		  if (anf_print_level >=2 )
		   {
		    printf("Representation of this element in the extention order:\n\n");
		    printf("   ");
                    anf_elt_write(ord,a_elt); printf(" =  ");
                    elt_h1= anf_elt_con(ord, a_elt);
                    anf_elt_write(ord,elt_h1); printf("\n");
		    printf("\nT2-Norm of this element: ");
		    h1= anf_elt_t2(ord, a_elt);
                    real_write(R, h1, 20); 
		    printf("\n\n");
		    real_delete(&h1);                    
		    anf_elt_delete(ord, &elt_h1);
		   }
	   	 }
		else
		 {
		  printf("The second field is not a subfield!\n\n"); 
		  goto  end;
		 }





          /*** Find the representation of the powers of the primitiv     ***/
	  /*** element in  sub_ord                                       ***/
                   
         	trans_pow_sub_ord= mat_new(n,n);
	
 		elt_h1= integer_anf_elt_lift(sub_ord, 1);
                anf_elt_to_mat_order_col(sub_ord, elt_h1, trans_pow_sub_ord, 1);
                anf_elt_to_mat_order_col(sub_ord, beta_elt, trans_pow_sub_ord, 2);
		anf_elt_delete(sub_ord, &elt_h1);

        	elt_h1= anf_elt_incref(beta_elt);
	        for (i=3; i<=n; i++)
		 {                  
		  elt_h2= elt_h1;
		  elt_h1= anf_mult(sub_ord, elt_h1, beta_elt);
		  anf_elt_delete(sub_ord, &elt_h2);
                  anf_elt_to_mat_order_col(sub_ord,elt_h1,trans_pow_sub_ord,i);
		 }
		anf_elt_delete(sub_ord, &elt_h1);  

		if (anf_print_level >=3 )
		 {
		  printf("\n\n\n\ntrans_pow_sub_ord= \n");
                  for (i=1; i<=n; i++)
		   {
                    for (j=1; j<=n; j++)
		      printf(" \t %d", mat_elt(trans_pow_sub_ord, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }



          /*** Find the representation of the powers of the primitiv     ***/
	  /*** element of sub_ord in ord                                 ***/
                   
         	trans_pow_ord= mat_new(nm,n);
	
 		elt_h1= integer_anf_elt_lift(ord, 1);
                anf_elt_to_mat_order_col(ord, elt_h1, trans_pow_ord, 1);
                anf_elt_to_mat_order_col(ord, a_elt, trans_pow_ord, 2);
		anf_elt_delete(ord, &elt_h1);

        	elt_h1= anf_elt_incref(a_elt);
                for (i=3; i<=n; i++)
		 {            
		  elt_h2= elt_h1;
		  elt_h1= anf_mult(ord, elt_h1, a_elt);
		  anf_elt_delete(ord, &elt_h2);
                  anf_elt_to_mat_order_col(ord, elt_h1, trans_pow_ord, i);
		 }
		anf_elt_delete(ord, &elt_h1);


		if (anf_print_level >=3 )
		 {
		  printf("\n\ntrans_pow_ord= \n");
                  for (i=1; i<=nm; i++)
		   {
                    for (j=1; j<=n; j++)
		      printf(" \t %d", mat_elt(trans_pow_ord, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }

          /*** Find the representation of the basis of sub_ord in ord    ***/

                mat_h2= mat_z_to_mat_real(R, trans_pow_ord);
                mat_h3= mat_z_to_mat_real(R, trans_pow_sub_ord);
                mat_h4= mat_ring_inverse(R,mat_h3);
		mat_h5= mat_ring_mult(R, mat_h2, mat_h4);  
	        trans_sub_ord_ord= mat_real_to_mat_z(R, mat_h5);

		if (anf_print_level >=3 )
		 {
		  printf("\n\nmat_h5= \n\n");
		  mat_real_write_aj(R, mat_h5, 15);
		  printf("\n \n");
		 }

		if (anf_print_level >=3 )
		 {
		  printf("\n\ntrans_sub_ord_ord= \n");
                  for (i=1; i<=nm; i++)
		   {
                    for (j=1; j<=n; j++)
		      printf(" \t %d", mat_elt(trans_sub_ord_ord, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }

		mat_delref(R, &mat_h2);
		mat_delref(R, &mat_h3);
		mat_delref(R, &mat_h4);
		mat_delref(R, &mat_h5);
		                                    

          /*** Find the representation an relative element in ord       ***/
                                                                   
		trans_rel_ord= mat_new(nm, nm);
                for (i=1; i<=m; i++)
		 { 
                  elt_h1= anf_elt_incref(vec_entry(rel_basis,i));
                  for (j=1; j<=n; j++)
		   { 
		    elt_h3= mat_order_col_to_anf_elt(ord, trans_sub_ord_ord, j);
		    elt_h2= anf_mult(ord, elt_h1, elt_h3);
                    anf_elt_to_mat_order_col(ord, elt_h2, trans_rel_ord, (i-1)*n+j);
	  	    anf_elt_delete(ord, &elt_h2);
	  	    anf_elt_delete(ord, &elt_h3);
		   }
		  anf_elt_delete(ord, &elt_h1);
	         }

		if (anf_print_level >=3 )
		 {
		  printf("\n\ntrans_rel_ord= \n");
                  for (i=1; i<=nm; i++)
		   {
                    for (j=1; j<=nm; j++)
		      printf(" \t %d", mat_elt(trans_rel_ord, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }
		 
		det= mat_z_det(Z, trans_rel_ord);
		det_rel= integer_incref(det);
		if (anf_print_level >=3 )
		 {
		  printf("\nDeterminant: ");
		  integer_write(det);
		  printf("\n \n");
		 }




          /*** Find the of ord in the relative basis if exists       ***/
                                                                   
		mat_h4= mat_z_to_mat_real(R, trans_rel_ord);
		h1=  conv_int_to_real(R, det); 
		h2= real_inverse(R, h1); 
		real_delete(&h1);
		h1= real_abs(R, h2);
		real_delete(&h2);
		mat_h5= mat_ring_scalar_right_mult(R,mat_h4,h1);
		mat_delref(R, &mat_h4);
		real_delete(&h1);
		mat_h4= mat_ring_inverse(R, mat_h5);

		if (anf_print_level >=3 )
        	 {
		  printf("\nmat_h4: \n\n");
		  mat_real_write_aj(R, mat_h4, 20);
		 }

	        trans_ord_rel= mat_real_to_mat_z(R, mat_h4);  
		trans_ord_rel_den= integer_abs(det);
		mat_delref(R, &mat_h4);
		mat_delref(R, &mat_h5);        


		mat_h4= mat_ring_mult(Z, trans_ord_rel, trans_rel_ord);
		if (anf_print_level >=3 )
		 {
		  printf("\n\nInverse test: \n");
                  for (i=1; i<=nm; i++)
		   {
                    for (j=1; j<=nm; j++)
		      printf(" \t %d", mat_elt(mat_h4, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }
		mat_delref(Z, &mat_h4);


		if (anf_print_level >=3 )
		 {
		  printf("\n\ntrans_ord_rel= \n");
                  for (i=1; i<=nm; i++)
		   {
                    for (j=1; j<=nm; j++)
		      printf(" \t %d", mat_elt(trans_ord_rel, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }

	        integer_delref(det);		 
		det= mat_z_det(Z, trans_rel_ord);
		if (anf_print_level >=3 )
		 {
		  printf("\nDenominator: ");
		  integer_write(trans_ord_rel_den);
		  printf("\n \n");
		 }
        
		
          /*** The order of relative basis multiplied by sub_ord basis  ***/

		rel_ord= order_trans_down(ord, trans_rel_ord);

	        integer_delref(det);		 
	        integer_delref(det_rel);		 
		
		 

          /*** Find the right order of the conjugates of ord over       ***/
          /***  sub_ord                                                 ***/
		 
                a_elt_con= anf_elt_con(ord, a_elt);  

		sort= anf_con_sort_sub(ord, sub_ord, a_elt_con, beta_elt_con); 

		if (anf_print_level >=2 )
		 {
                  printf("\n\n\n\nThe conjugates of this element in the suborder:\n");
                  anf_elt_write(sub_ord,beta_elt_con); printf("\n\n");
                  printf("\nThe conjugates of this element in the extention order:\n");
                  anf_elt_write(ord,a_elt_con); printf("\n\n");
  
                  printf("\nThe right order of the conjugates over the suborder:\n\n");
		  printf("   ");
		  for( j=1; j<= n; j++)   
	           {
		    for( i=1; i<= m; i++) 
		      printf("  %d ", anf_rel_sort_ordering_elt(sort,j,i));
	            printf("     ");
	           }
		  printf("\n");

	 	  printf("\n\n\nF^(j)'s without signature: %d \n", 2*order_r2(sub_ord));
	 	  printf("\n\n\nSignatures over F^(j): \n");
                  for (j= 1;j<= order_r1(sub_ord); j++) 
	  	   {
	 	    sj= anf_rel_sort_real_zeroes_elt(sort,j);
		    tj= anf_rel_sort_comp_zeroes_elt(sort,j);
		    printf("\nF^(%d):  s= %d,  t= %d ", j, sj, tj); 
		   }
                  printf("\n\n");

                  printf("\n\nThe sorted conjugates over the suborder:\n\n");  
		  for( j=1; j<= n; j++) 
	           {
		    for( i=1; i<=m; i++) 
		     {       
                      int1= anf_rel_sort_ordering_elt(sort,j,i);
		      comp_h1= anf_elt_ith_con(ord, a_elt_con, int1 );
		      comp_write_aj(C, comp_h1, 20);
		      printf("\n");
                      comp_elt_delete(C, &comp_h1);
		     }  
	 	    printf("\n");
	           }
		  printf("\n\n");                                             

		 }  /* endif: anf_print_level */

          /*** Computation of the conjugated relativ integral bases     ***/

		rel_con= rel_bases_con(ord, sub_ord, rel_basis, sort);
                
		if (anf_print_level >=2 )
		 {
                  printf("\n\n\nOutput of the conjugated relativ integral bases:\n\n");
		  for( i=1; i<= sub_r1r2; i++) 
		   {
	  	    printf("\n(i= %d):\n", i);
		    mat_comp_write_aj(C, vec_entry(rel_con,i), 20);
		    printf("\n\n");
		   }
		  printf("\n\n");     
		 }

          /*** Computation the solution of the norm equation     ***/


                printf ("(nm = %d, s = %d)\n",nm,order_r1(rel_ord));
                printf ("TASK : \n");


                /*** Which subroutine: both (0) or rel_order... (1) or  ***/
                /***                   order_lat... (2)                 ***/ 
                
		scanf("%d", &subr); 
		gets(str);

		if ( (subr<0) || (subr>2) )    
		  error_internal("spri.c: subr has a false value!");



		/* read abs_value */
               
	        scanf("%d", &abs_value);
		gets(str);
                if (abs_value==1)
		  printf("N^(j)( ) will be solve!\n");
                 else
		  printf("|N^(j)( )| will be solve!\n");
    

		/* read find_all */
               
	        scanf("%d", &find_all);
		gets(str);
                if (find_all==1)
		  printf("All solutions  of N^(j)( ) will be search!\n");
                 else
		  printf("One solutions  of N^(j)( ) will be search!\n");



		/* read the norms K in form of an algebraic integer of sub_ord */
                          
		K= vec_new(sub_r1r2);

		norm_elt= anf_elt_read(sub_ord);
		printf("relative norm: ");
	        anf_elt_write(sub_ord, norm_elt);                  
	        printf("\n"); 
	  
		printf("absolute conjugated relative norms:  ");
      	        for (i=1;i<=sub_r1r2;i++) 
 	         {
                  comp_h1= anf_elt_ith_con(sub_ord, norm_elt, i);
 	          h1= comp_norm(C, comp_h1);
	          vec_entry(K,i)= real_sqrt(R, h1);
	          real_write_aj(R, vec_entry(K,i), 15);
                  comp_elt_delete(C, &comp_h1);
                  real_delete(&h1);
	         }          
		printf("\n");


	        h1= conv_int_to_real(R, 1);
     	        for (i=1;i<=sub_r1;i++) 
     	         {                                                            
	          h2= h1;
		  h1= real_mult(R,h2,vec_entry(K,i));
	          real_delete(&h2);
     	         }                         
     	        for (i=sub_r1+1;i<=sub_r1r2;i++) 
     	         {                                                            
	          h2= h1;
	          h3= real_power(R, vec_entry(K,i), 2);
		  h1= real_mult(R,h2, h3);
	          real_delete(&h2);
	          real_delete(&h3);
     	         }                         

		prod_k= conv_real_to_int_round(R, h1);
		printf("absolute norm: %d \n", prod_k);

	        real_delete(&h1);



 
               rel_order_fincke_find_gamma_prod(sub_ord, K, &G, &dum2, sort);           

                          
	} 

end:

/*** End  *********************************************************************/
 
}         

