#include "kant.h" 
 
matrix
mat_comp_gram WITH_2_ARGS(
	t_handle,		C,
	matrix,		basis
)
/*******************************************************************************
 
AJ April 1992
Last modification: -

 
 
 
Description:
 
	Computation of the Gram-matrix of a complex lattice basis.
	

 
Calling sequence:
 
	gram= mat_comp_gram(C, basis);
 
      	t_handle  	C       = t_handle the complex field
      	matrix          basis   = t_handle of a matrix
        matrix		gram    = t_handle of the Gram-matrix      
 
History:
 
	92-04-02 AJ    written
 
*******************************************************************************/
{
	block_declarations;

	matrix	mat1, mat2;   
	int 	i, j, row, col;  
	t_handle  R;

        row = mat_row(basis);
        col = mat_col(basis);

 	mat1 = mat_new( col, row );
    
	R= comp_real_field(C); 

	for (i=1; i<= row; i++)
	 for (j=1; j<= col; j++)
	   mat_elt(mat1,j,i) = comp_conjugate(C,mat_elt(basis,i,j));

	mat2 = mat_ring_mult(C,mat1,basis);

	mat_delref(C,&mat1);

	return(mat2);
}
               
