#include "kant.h"

t_logical
order_find_suborder WITH_2_ARGS(
	order,		ord,
	order *,	subord
)
/*******************************************************************************
 
Description:
 
	The function returns a suborder of ord if possible.

 
Calling sequence:
 
	ok= order_find_suborder(ord, &subord);
 
      	order  	        ord      = t_handle of an order 
      	order  	        subord   = t_handle of a suborder 
      	t_logical 	ok       = 1, if a suborder is found
      		                   0, if a suborder isn't found
 
History:
 
	92-07-14 AJ    written
 
*******************************************************************************/
{  
	block_declarations;         

  	int		i, n, deg, cnt;
   	t_handle        R, Z;
        t_real          ubound, loceps;
	t_real          h1, h2, h3, h4, h5, real_n, real_abs_disc, bound1, bound2; 
	integer_big	int1;
                               
	order		ord_h1;
	anf_elt 	tst_elt, elt_h1;  

        matrix          trans, inv_trans;

	lattice 	lat, lll_lat;
	lat_enum_env	env, lll_env;    
        lat_elt         lat_vec;


	t_poly	pol;


/*** Initialisation  **********************************************************/
                        
	n=  order_abs_degree(ord);
        
        order_reals_assure(ord);
	order_disc_assure(ord);
	
        R = order_reals(ord);    
        Z= m_z_str_incref(structure_z);

        loceps= real_make(R, 10, -real_dec_prec(R)+6 );  


/*** Computation of an upper bound of a primitive element of an suborder *****/   
    
	real_n= conv_int_to_real(R, n);
	int1= integer_abs(order_disc(ord));
	real_abs_disc= conv_int_to_real(R, int1);
	integer_delref(int1);

        /* first bound */
                      
	h1= hermite_constant(R, n);         
        h2= real_mult(R, h1, real_abs_disc);
	h3= real_divide(R, h2, real_n);
	bound1= real_root(R, h3, n-1);
	real_delete(&h1);
	real_delete(&h2);
	real_delete(&h3);

        /* second bound */
                      
	h1= hermite_constant(R, n-1);         
        h2= real_mult(R, h1, real_abs_disc);
	h3= real_divide(R, h2, real_n);
	h4= real_root(R, h3, n-1);
	h5= conv_double_to_real(R, (double)(n)/4.0 );
	bound2= real_add(R, h4, h5);
	real_delete(&h1);
	real_delete(&h2);
	real_delete(&h3);
	real_delete(&h4);
	real_delete(&h5);    

	if (real_compare(R, bound1, bound2)==-1)
	  ubound= real_incref(bound1);
	 else
	  ubound= real_incref(bound2);

	if (anf_print_level > 3)
	 {
	  printf("\nBounds of primitive element of a suborder: ");
          real_write(R, bound1, 15);
	  printf(" ,   ");
          real_write(R, bound2, 15);
	  printf("\n\nMinimum: ");
          real_write(R, ubound, 15);
	  printf("\n \n");
         }

/*** Initialisation of enumeration environment  ******************************/

	order_lat(ord, &lat, &env);

        lll_lat = lat_lll_reduce(lat,&trans,&inv_trans);
        lll_env = lat_enum_create(lll_lat);

        lat_enum_status_set_new   (lll_env);
        lat_enum_request_set_next (lll_env);
        lat_enum_strategy_set_up  (lll_env);          
        lat_enum_ubound (lll_env) = real_incref (ubound);


/*** Loop of the enumeration   ***********************************************/

	while (lat_enum(lll_lat,lll_env))
	{  

         /*** Test if the founded element creates a suborder             ****/
                                            
         lat_vec  = lat_elt_move (lll_lat,lat_enum_act_coefs(lll_env),trans);
                              
         tst_elt = lat_elt_to_anf_elt (lat, lat_vec, ord);
	 lat_elt_delete (lll_lat,&lat_vec);

 
         if (anf_print_level>=0)
          {
           elt_h1= anf_elt_con(ord, tst_elt);  

           cnt= 0;
           for (i=1; i<= 10; i++)
            {
             if (real_equality_eps(R, anf_con(elt_h1,1), anf_con(elt_h1,i), loceps))
              cnt++;
            }
           
           if (cnt>= 4)
            {
             printf("\ntst_elt: ");
             anf_elt_write(ord,tst_elt);
             printf("=\n");
             anf_elt_write(ord,elt_h1);
             printf("\n\n");
            }
          }

	 if ( !anf_elt_is_primitive(ord,tst_elt) && 0 )
	  {      
 	   /** Determine the suborder                                     **/
	   pol= anf_elt_minpoly(ord, tst_elt);
	   ord_h1= order_equation_create(Z, pol);
	   m_poly_z_delref(structure_pring_z, pol);
	   *subord= order_maximal(ord_h1);
/*	   *subord= order_incref(ord_h1);*/
	   order_delete(&ord_h1);
	   ring_delete(&Z);

 	   /** Deletion of storage and return 1                           **/

	   lat_enum_delete(lat,&env);
	   lat_delete(&lat);
	   lat_enum_delete(lll_lat,&lll_env);
	   lat_delete(&lll_lat);
           mat_delref(Z,&trans);
           mat_delref(Z,&inv_trans);
           ring_delete(&Z);

	   real_delete(&bound1);
	   real_delete(&bound2);
	   real_delete(&ubound);
	   real_delete(&real_n);
	   real_delete(&real_abs_disc);
	   anf_elt_delref(ord,&tst_elt);   

	   return 1; 
	  } 

         anf_elt_delref(ord,&tst_elt);
         anf_elt_delref(ord,&elt_h1);

	}   /* end while */ 
	
/*** End: return ***********************************************************/
                                    
	lat_enum_delete(lat,&env);
	lat_delete(&lat);
	lat_enum_delete(lll_lat,&lll_env);
	lat_delete(&lll_lat);
        mat_delref(Z,&trans);
        mat_delref(Z,&inv_trans);
        ring_delete(&Z);

	real_delete(&loceps);
	real_delete(&bound1);
	real_delete(&bound2);
	real_delete(&ubound);
	real_delete(&real_n);
	real_delete(&real_abs_disc);
       

	return 0;

} 

