#include "kant.h" 
#include "anf_rel_sort.h" 


t_void
rel_order_fincke_find_gamma_opt WITH_5_ARGS( 
	order,		sub_ord,
	vector,         K,
	vector *,       gamma,
	vector *,       lambdas,
        anf_rel_sort,   sort
)
/*******************************************************************************
 
Description:
 
	The function finds the optimal gamma values for the relative
        norm equations.

 
Calling sequence:
 
	rel_order_fincke_find_gamma_opt(ord, K, &gamma, sort);
 
      	order  	        sub_ord  = t_handle of the suborder 
      	vector          K        = the absolute relative norm
      	vector          gamma    = the optimal gamma's       
        anf_rel_sort    sort     = the sorting of the conjugates
 
History:
 
	93-01-06 AJ    written
 
*******************************************************************************/
{  
	block_declarations;

	integer_small	i, j, n, cnt, r1r2, m, h1;
        t_real          ubound, step, temp1, minh, min, one, h, p1, p2;
        t_real          temp2, temp3, g;
	t_handle	R;
        vector		lambda, lambda_store;    
        double          la;
	char		str[200];
        

          
/*** Initialisation  **********************************************************/

	n= order_abs_degree(sub_ord); 
        m= anf_rel_sort_m(sort);
	r1r2= order_r1(sub_ord)+order_r2(sub_ord);
	R= order_reals(sub_ord); 

        one = conv_double_to_real (R,1.0);   
        if (r1r2>4)
          ubound= conv_int_to_real(R, 5);           
         else
          ubound= conv_int_to_real(R, 5);           


        if (r1r2>4)
          step= conv_double_to_real(R, 2.0);           
         else
          step= conv_double_to_real(R, 2.0);           
                              

        lambda_store= vec_new(r1r2);
        for (i=1; i<= r1r2; i++)
	 {
	  scanf("%lf", &la);
	  gets(str); 
	  vec_entry(lambda_store,i)= conv_double_to_real(R, la);
	 }                   
 

/*** Loop of some lambdas            ******************************************/

	i= 1;                        
        cnt= 0;
          
        lambda= vec_new(r1r2);
        lambda_store= vec_new(r1r2);
        for (j= 1; j<=r1r2; j++)
	  vec_entry(lambda,j)= conv_double_to_real(R, 2.0);
          
        cnt++;
        min= rel_order_fincke_min_fkt (R,lambda, K, sort);       
        for (j= 1; j<=r1r2; j++)
	  vec_entry(lambda_store,j)= real_incref(vec_entry(lambda,j));
    
        if (anf_print_level>=5)
         {
          mat_real_write_aj(R, lambda, 15); 
	  printf(",     min_fkt= ");
          real_write_aj(R, min, 10);
          printf("\n");
         }

         do
	 {     
 	  temp1= vec_entry(lambda,i);
          vec_entry(lambda,i)= real_add(R, temp1,step);
 	  real_delete(&temp1);

          if ( real_compare(R, vec_entry(lambda,i), ubound)<= 0 )
            {
             i= 1;  

             cnt++;
             minh = rel_order_fincke_min_fkt (R,lambda, K, sort);       
             if (anf_print_level>=5)
              {
               mat_real_write_aj(R, lambda, 15); 
	       printf(",     min_fkt= ");
               real_write_aj(R, minh, 10);
               printf("\n");
              }

             if (real_compare(R, min, minh) >0 )
               {   
                real_delete(&min);
 		min= real_incref(minh);
                real_delete(&minh);
                for (j= 1; j<=r1r2; j++)
                 {
                  real_delete(&vec_entry(lambda_store,j));
	          vec_entry(lambda_store,j)= real_incref(vec_entry(lambda,j));
                 }
               }
              else
                real_delete(&minh);
            }
           else
            {
 	     temp1= vec_entry(lambda,i);
             vec_entry(lambda,i)= conv_double_to_real(R, 2.0);
 	     real_delete(&temp1); 

	     i= i+1;
 	    }
         }
        while (i<=r1r2);

        vec_delete(R, &lambda);
        real_delete (&min);

/*** optimal lambdas found *****************************************************/
               
        if (anf_print_level>=5)
         {
	  printf("\n\nAnzahl der Tupel: %d \n\n", cnt);
	  printf("\nOptimale lambdas \n");
          mat_real_write_aj(R, lambda_store, 15); 

          printf("\nMinimum \n");
          real_write_aj(R, min, 10);

	  printf("\n \n");
         }
        
/*** Determination of optimal gammas ******************************************/

        *gamma= vec_new(r1r2);
        *lambdas= vec_new(r1r2);
  
        for (j= 1; j<=r1r2; j++)
         {   
          /* the function g(t)^(m/2)  */ 

          h= H (R,vec_entry(lambda_store,j),one);
          temp1 = real_subtract (R,one,h);    
          temp2 = real_real_power (R,vec_entry(lambda_store,j),h);
          temp3 = real_divide  (R,temp2,vec_entry(lambda_store,j));
          p1 = real_mult (R,temp1,temp2);
          real_delete (&temp1);
          real_delete (&temp2); 
          p2 = real_mult (R,h,temp3);
          real_delete (&temp3);
          real_delete (&h);

          g = real_add (R,p1,p2);

          real_delete (&p1);
          real_delete (&p2);
        
          temp1= real_power (R,g,m);
          temp2= real_sqrt(R, temp1);
          temp3= real_mult(R, vec_entry(K,j), temp2);

          vec_entry(*gamma,j)= real_subtract(R, temp3,vec_entry(K,j));
          vec_entry(*lambdas,j)= real_incref(vec_entry(lambda_store,j));

          real_delete (&temp1);
          real_delete (&temp2); 
          real_delete (&temp3);
          real_delete (&g); 
               
         }


/*** end  *********************************************************************/

        vec_delete(R, &lambda_store);
        real_delete (&one);
        real_delete (&ubound);
        real_delete (&step);

	return;

}    
    




t_real
rel_order_fincke_min_fkt WITH_4_ARGS (
			 t_handle   ,  R     ,
                         vector     ,  lambda,
                         vector     ,  K,
                         anf_rel_sort, sort
)

/*******************************************************************************

Description:
                                                             
     Computes the value of minimum function desc. in Jurk.
     The function dependes on two additional parameters (K, lambda). 


Calling sequence:                                           

       t_handle    R      : A real field
       vector      lambda : lambda values
       vector      K      : absolute values of the relative norm
       t_real      f      : result of the function


       f = rel_order_fincke_min_fkt (R,lambda, K, sort);       
                            
History:                                 

    07.01.93     AJ    first version

********************************************************************************/
{
            t_real         one,h;
            t_real         temp1,temp2,temp3, temp4;
            t_real         sum, prod, g, p1,p2,p3, erg;   
            integer_small  i,j,jh,r1r2, r2, m, r1, n;
 
                  
  r1r2= vec_length(lambda);             
  m= anf_rel_sort_m(sort);
  r1= vec_length(anf_rel_sort_real_zeroes(sort));
  r2= r1r2-r1;             
  n= r1r2+r2;             
  one = conv_double_to_real (R,1.0);   

/* The sum in the minimum function  */

  sum = conv_int_to_real (R,0);   
  for (j= 1; j<=r1r2; j++)
   {   
    /* the function g(t)  */ 

    h= H (R,vec_entry(lambda,j),one);
    temp1 = real_subtract (R,one,h);    
    temp2 = real_real_power (R,vec_entry(lambda,j),h);
    temp3 = real_divide  (R,temp2,vec_entry(lambda,j));
    p1 = real_mult (R,temp1,temp2);
    real_delete (&temp1);
    real_delete (&temp2); 
    p2 = real_mult (R,h,temp3);
    real_delete (&temp3);
    real_delete (&h);

    g = real_add (R,p1,p2);

    real_delete (&p1);
    real_delete (&p2);

    /* the j-th summand  */ 

    temp1= real_root (R,vec_entry(K,j),m);
    temp2= real_power(R, temp1, 2);
    temp3= real_mult(R, temp1, g);
    temp4= sum;
    sum= real_add(R, sum, temp3);  
    real_delete (&temp4); 

    if (j>r1)  
     {
      temp4= sum;
      sum= real_add(R, sum, temp3);  
      real_delete (&temp4); 
     }
    
    real_delete (&temp1);
    real_delete (&temp2); 
    real_delete (&temp3);
    real_delete (&g); 
   }

/* The first factor in the minimum function  */

  temp1= real_power(R, sum, n);   

  p1= real_sqrt(R, temp1);

  real_delete (&temp1);
  real_delete (&sum);

/* The second factor in the minimum function  */
             
  p2 = conv_int_to_real (R,1);   
  for (j= 1; j<=r1; j++)
   {
    i=  anf_rel_sort_real_zeroes_elt(sort,j)+anf_rel_sort_comp_zeroes_elt(sort,j)-1;

    temp1= real_log (R,vec_entry(lambda,j));
    temp2= real_divide (R,one,temp1);
    temp3= real_power(R, temp2, i);

    temp4= p2;
    p2= real_mult(R, temp4, temp3);

    real_delete (&temp1); 
    real_delete (&temp2); 
    real_delete (&temp3); 
    real_delete (&temp4); 
   }


/* The third factor in the minimum function  */

  p3 = conv_int_to_real (R,1);   
  for (j= r1+1; j<=r1r2; j++)
   {
    temp1= real_log (R,vec_entry(lambda,j));
    temp2= real_divide (R,one,temp1);
    temp3= real_power(R, temp2, m-1);

    temp4= p3;
    p3= real_mult(R, temp4, temp3);

    real_delete (&temp1); 
    real_delete (&temp2); 
    real_delete (&temp3); 
    real_delete (&temp4); 
   }

/* The result of the minimum function  */

   temp1= real_mult(R, p1,p2);

   erg= real_mult(R, temp1,p3);

   real_delete (&one); 
   real_delete (&temp1); 
   real_delete (&p1); 
   real_delete (&p2); 
   real_delete (&p3); 

   return erg;

}



