#include "kant.h" 
#include "thue.h"

t_real
thue_anf_elt_con_max WITH_2_ARGS(
        thue,           th,
	anf_elt,	alpha
)
/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	anf_elt		beta;
	integer_small	deg, i;
	t_handle	R, C;
	t_real		maximum, norm, x;
        t_comp          con;
        order           ord;

        ord = thue_order(th);
        R = order_reals(ord);
        C = comp_create(real_dec_prec(R));
        deg = thue_abs_degree(th);
        maximum = ring_zero(R);
        for (i=1; i<=deg; i++)
                {
                con = anf_elt_ith_con(ord, alpha, i);
                norm = comp_norm(C, con);
                x = real_sqrt(R, norm);
                if (real_compare(R, maximum, x) == -1) 
                        {
                        real_delete(&maximum);
                        maximum = real_incref(x);
                        }
                real_delete(&x);
                real_delete(&norm);
                comp_delete(&con);
                }       
        ring_delete(&C);
        return maximum;
}
