#include "kant.h"
#include "thue.h" 

t_real
thue_waldschmidt_B1 WITH_5_ARGS(
                thue,           th,
                t_real,         c4,
                t_real,         c5,
                t_real,         c6,
                t_real,         c7)

/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	t_handle	R;
	t_real		B1, factor, m_one;
        t_real          h1, h2, h3, h4;          
        order           ord;
        
        ord = thue_order(th);
        R = thue_reals(th);

        factor = conv_int_to_real(R, 10);
        B1 = conv_int_to_real(R, 1); 
        m_one = conv_int_to_real(R, -1);
        for (;;)
                {
                h1 = B1;
                B1 = real_mult(R, h1, factor);
                real_delete(&h1);
                h1 = real_mult(R, B1, c4);
                h2 = real_subtract(R, c5, h1);
                real_delete(&h1);
                h1 = real_mult(R, c6, m_one);
                h3 = real_log(R, B1);
                h4 = real_mult(R, c7, h3);
                real_delete(&h3);
                h3 = real_subtract(R, h1, h4); 
                real_delete(&h1);
                real_delete(&h4);
                if (real_compare(R, h2, h3) == -1)
                        { 
                        real_delete(&h2);
                        real_delete(&h3);
                        break;
                        }
                else
                        {
                        real_delete(&h2);
                        real_delete(&h3);
                        }
                } 
        h1 = B1;
        B1 = real_divide(R, h1, factor); 
        real_delete(&h1);
        real_delete(&m_one);

        return B1;
}






