      SUBROUTINE START(NAME)
*
C     ******************************************************************
C     *                                                                *
C     *                    S U B R O U T I N E                         *
C     *                                                                *
C     *                         S T A R T                              *
C     *                                                                *
C     ******************************************************************
C
C
*DOC             Event-handling and debug routine
**DOC
*INDEX  START (IN/1): Internal Debug routine
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       This routine must be called exactly as often as END.
**DOC       IER is set to zero. In dependence on DLEVEL it measures the
**DOC       CPU-time and administrates the number of subroutine calls.
**DOC       If DLEVEL=1 or DLEVEL=3 it writes a message on DNROUT.
**DOC       Exact description: cf. END.
**DOC
**DOC   (2) PARAMETER (IN):
**DOC       NAME   (STR)     name of calling subroutine, exactly six characters
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC       -
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       IER    = 0
**DOC       ERRFLG = 0
**DOC       LVLPTR       < LVLPTR + 1 (subroutine level)
**DOC       SUBNAM(LVLPTR) = NAME
**DOC       SUBTCNT(.)   if 1<DLEVEL<7:  incremented by one
**DOC       SUBTI1(.)    if 1<DLEVEL<5:  stores the actual CPU-time
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC       START       GETSUB
**DOC       END         SECOND
**DOC       IERDEL      TSTSET
**DOC
**DOC   (7) INCLUDE-FILES USED:
**DOC       FIELD
**DOC
**DOC   (8) AUTHOR(S):
**DOC       JS       19.02.87
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       JS       01.09.87
**DOC       JS       01.09.87
**DOC       JS       17.08.89  IERDEL
**DOC       FS       30.07.90  Different handling of main programs
**DOC       JS       13.06.91  TSTSET
**DOC
%include 'field.inc'
*
      INTEGER DUMMY
      CHARACTER*6 NAME
      CHARACTER*3 BLANKS,STRLVL
      DATA BLANKS /'   '/
*
*  Was the calling program a a main program?
*
      IF ( NAME(1:2).EQ.'MP' ) THEN
         DUMMY = DLEVEL
         DLEVEL = 4
      CALL SYSINI('APOLLO')
         CALL INITMP(NAME)
         CALL OUT1MP(1)
      ENDIF
*
*  Output of subroutine name and level
*
      IF (DLEVEL.EQ.1.OR.DLEVEL.EQ.3) THEN
          WRITE(STRLVL,'(I3)') LVLPTR
          WRITE(DNROUT,1000) NAME,(BLANKS,I=1,LVLPTR),STRLVL
1000      FORMAT(' START ',A6,20A3)
      ENDIF
*
*  (Time) logging
*
      IF (DLEVEL.GT.1.AND.DLEVEL.LT.7) THEN
         CALL GETSUB(NAME)
         SUBCNT(SUBPTR) = SUBCNT(SUBPTR) + 1
         IF (DLEVEL.LT.5) CALL SECOND(SUBTI1(LVLPTR+1))
      ENDIF
*
*   Incrementing the level counter, resetting error flags
*
      CALL IERDEL()
      LVLPTR = LVLPTR + 1
      SUBNAM(LVLPTR) = NAME
*
      IF ( NAME(1:2).EQ.'MP' ) DLEVEL = DUMMY
*     
* Setting TSTFLG
*
      CALL TSTSET (NAME)
      RETURN
      END
