/*******************************************************************************
-----------------------------------------------------------------------------

    ACHTUNG:
    Zur Vermeidung von zu grossen Kompatibilitaetsproblemen duerfen
    Aenderungen in den Strukturdefinitionen nur nach gemeinsamer
    Eroerterung bzw. Einigung zwischen der Cayley- und der Kant-Gruppe
    durchgefuehrt werden.
    Sydney, 25.9.1992             John Cannon, Johannes Gf. Schmettow

-----------------------------------------------------------------------------

    ATTENTION:

    To avoid major problems of incompatibility, changes to the structure
    definitions should only be made after common discussion and agreement
    between the Cayley and Kant groups.

    Sydney, 25/9/1992             John Cannon, Johannes Ct. Schmettow

-----------------------------------------------------------------------------
                   
anf_elt.h
   
Header file for algebraic numbers.
This file should only be #included by anf.h.
    
An algebraic number ("anf_elt") is 
  - either a small integer 
  - or a big integer     
  - or a pair of 
    -- a denominator (which is a positive rational integer) and 
    -- an array of algebraic numbers of a given subfield referring to a 
       relative basis. The denominators of these coefficients *should*
       (but need not) be one.
  - or a real array of approximations of its conjugates
 
History:
        92-09-17 JS        Move to Cayley V4
        92-06-04 JS        split off from anf.h

*******************************************************************************/

/*******************************************************************************
/
/  Structure definition for algebraic numbers
/
*******************************************************************************/
 
typedef struct
	{
		t_block_header	trbl_hdr;
		integer_big	anf_elt_denomin;
	}	
	anf_elt_header;
  
typedef struct
	{
		anf_elt_header	anf_elt_hdr;
		anf_elt		anf_elt_coefs[VARIABLE_LENGTH];
	} 	
	anf_elt_struct;

 
/*******************************************************************************
/
/   Macros for accessing structure items of algebraic numbers
/
*******************************************************************************/
  
 
/*   
    length of header (internal use)
    total size of space required by the number (internal use)
*/
 
#define ANF_ELT_HDR_LEN	MEM_BYTES_TO_WORDS(sizeof(anf_elt_header))
#define anf_elt_required_space(n)	((n) + ANF_ELT_HDR_LEN)
  

/*
    Conversion between handles and bigs (internal use)
*/
  
#ifdef POSH
#define anf_elt_handle_to_big(h)	(integer_BETA + (h))
#define anf_elt_big_to_handle(a)	((a) - integer_BETA)
#else
#define anf_elt_handle_to_big(h)	(integer_BETA - (h))
#define anf_elt_big_to_handle(a)	(integer_BETA - (a))
#endif

/*
    recognizing small integers
    recognizing integers
*/
 
#define anf_elt_is_single(a) integer_is_single(a)
#define anf_elt_is_integer(a) (anf_elt_is_single(a) || \
		block_type(anf_elt_big_to_handle(a)) == INTBIG_BLOCK_TYPE)
  
  
  
 
/*
    accessing 
       ... a certain place within the structure (internal use)
       ... the denominator
       ... a certain coefficient
*/
  
#define anf_elt_access(a) \
	((anf_elt_header *) mem_access(anf_elt_big_to_handle(a)))
#define anf_elt_den(a) \
	(anf_elt_access(a) -> anf_elt_denomin)
#define anf_elt_coef(a, i) \
	(((anf_elt_struct *) anf_elt_access(a)) -> anf_elt_coefs[(i)-1])
 

/*
    allocating space for an algebraic number
*/
 
#define anf_elt_alloc(a, reldeg)	\
	{ \
		a = (anf_elt) anf_elt_handle_to_big(\
			mem_alloc_words_zero(anf_elt_required_space(reldeg))); \
		block_init(anf_elt_big_to_handle(a), ANF_ELT_BLOCK_TYPE); \
	}
    
   
/*                                
    anf_elt-/reference counter maintenance
       - reassigning an algebraic number
       - increment reference counter 
       - has the number no references? (internal use)
       - has the number other references? (internal use)
       - deleting an algebraic number
*/
  
#define anf_elt_reassign(ord, a, b)	\
    { anf_elt _anf_elt_temp = a; a = b; anf_elt_delete(ord, &_anf_elt_temp); }
#define anf_elt_incref(a) ((anf_elt) (anf_elt_is_single(a) ||\
				block_incref(anf_elt_big_to_handle(a))), a)
#define anf_elt_has_no_refs(a) (! anf_elt_is_single(a) && \
				block_has_no_refs(anf_elt_big_to_handle(a)))
#define anf_elt_has_other_refs(a) (anf_elt_is_single(a) || \
				block_has_other_refs(anf_elt_big_to_handle(a)))

#define anf_elt_delete(ord, a) \
		 (anf_elt_is_integer(*(a)) \
		  ? (integer_delete(a), 0) \
		  : (anf_elt_delete_hard(ord, *(a)), *(a) = MEM_NH) \
		)
 
#define anf_elt_delref	anf_elt_delete

/*******************************************************************************
/
/  Structure definition for conjugate vector of algebraic numbers
/
*******************************************************************************/
 
typedef struct
	{
		t_block_header	trbl_hdr;
		t_real		anf_con_comps[VARIABLE_LENGTH];
	} 	
	anf_con_struct;

 
/*******************************************************************************
/
/   Macros for accessing structure items of conjugate vector
/
*******************************************************************************/
  
 
/*   
    length of header (internal use)
    total size of space required by the number (internal use)
*/
 
#define ANF_CON_HDR_LEN			BLOCK_HEADER_WORDS
#define anf_con_required_space(n)	((n) + ANF_CON_HDR_LEN)
  

/*
    recognizing conjugate vectors (if not integers)
*/
 
#define anf_elt_is_con(a) \
    (!anf_elt_is_single(a) && block_type(anf_elt_big_to_handle(a)) == ANF_CON_BLOCK_TYPE)
  
  
   
/*
    accessing 
       ... a certain place within the structure (internal use)
       ... a certain component
*/
  
#define anf_con_access(h)    \
			((anf_con_struct *) mem_access(anf_elt_big_to_handle(h)))
 
#define anf_con(a, i)   (anf_con_access(a) -> anf_con_comps[(i)-1])

  
/*
    allocating space for conjugate vector
*/
 
#define anf_con_alloc(a, reldeg)	\
	{ \
		a = (anf_elt) anf_elt_handle_to_big(\
			mem_alloc_words_zero(anf_con_required_space(reldeg))); \
		block_init(anf_elt_big_to_handle(a), ANF_CON_BLOCK_TYPE); \
	}
    
