#ifndef _COMP_E_
#define _COMP_E_

#include "integer.e"
#include "ring.h"
#include "real.e"
#include "mp.e"
#include "mp.h"

/*
** Structure fo the block containing a complex field.
*/

typedef struct
	{
		t_ring_common	ring_hdr;

		t_handle		rg_comp_real_field;
		integer_small	rg_comp_beta_prec;
		integer_small	rg_comp_dec_prec;
	}
	t_comp_table;

/*
** Access to the information of a complex field.
*/

#define comp_access(h)		((t_comp_table *) ring_access(h))

#define comp_real_field(h)	(comp_access(h) -> rg_comp_real_field)
#define comp_beta_prec(h)	(comp_access(h) -> rg_comp_beta_prec)
#define comp_dec_prec(h)	(comp_access(h) -> rg_comp_dec_prec)

#define comp_create( prec )		comp_create_hard( prec )

/*
 *	Macros to incref and delete complex fields.
 */

#define m_comp_str_incref(c)	(block_incref(c))
#define m_comp_str_delete(c)	(comp_str_delete(0,&c))

/*
** Type of a complex number.
** Stored as an array of two mp_floats.
*/

#if 0
typedef mp_float_array	t_comp;
#endif

/*
** Allocation of a complex number.
*/

#define comp_alloc( bas, bprec ) \
		mp_float_array_alloc( 2, bas, bprec )

/*
** Splitting up a complex number to two mp_floats.
*/

#define comp_split_mp( a, are, aim ) \
	( comp_get_real( a, are ), comp_get_imag( a, aim ) )

#define comp_get_real( a, are ) \
	( are = mp_array_element( a, 0 ) )

#define comp_get_imag( a, aim ) \
	( aim = mp_array_element( a, 1 ) )

/*
** Decrementing reference count of a complex number.
*/

/* changed by MJ 14.1.93 to lines below due to a mail form Allan
#define comp_delete( pa ) \
	( block_decref_delete( *(pa) ), *(pa) = 0 ) 
*/  

#define comp_delete( pa ) \
	( mp_delete_float_array( *(pa) ), *(pa) = 0 )


/*
** Increase of reference count of a complex number.
*/

#define comp_incref( a ) \
		block_incref( a )

extern t_comp comp_add P_((t_handle,t_comp,t_comp));
extern t_comp comp_conjugate P_((t_handle,t_comp));
extern t_comp comp_divide P_((t_handle,t_comp,t_comp));
extern t_comp comp_elt_incref P_((t_handle,t_comp));
extern t_comp comp_inverse P_((t_handle,t_comp));
extern t_comp comp_make P_((t_handle,t_real,t_real));
extern t_comp comp_minus_one P_((t_handle));
extern t_comp comp_mult P_((t_handle,t_comp,t_comp));
extern t_comp comp_negate P_((t_handle,t_comp));
extern t_comp comp_one P_((t_handle));
extern t_comp comp_power P_((t_handle,t_comp,t_int));
extern t_comp comp_sqrt P_((t_handle,t_comp));
extern t_comp comp_subtract P_((t_handle,t_comp,t_comp));
extern t_comp comp_zero P_((t_handle));
extern t_handle comp_create_hard P_((t_int));
extern t_handle comp_str_incref P_((t_handle,t_handle));
extern t_handle glue_comp_add P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_comp_argument P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_comp_comp P_((t_handle,t_handle,t_handle));
extern t_handle glue_comp_complex_field P_((t_handle));
extern t_handle glue_comp_conjugate P_((t_handle,t_handle));
extern t_handle glue_comp_eq P_((t_handle,t_handle,t_int,t_handle,t_handle,t_int));
extern t_handle glue_comp_inverse P_((t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_comp_is_minus_one P_((t_handle,t_handle));
extern t_handle glue_comp_is_one P_((t_handle,t_handle));
extern t_handle glue_comp_is_zero P_((t_handle,t_handle));
extern t_handle glue_comp_modulus P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_comp_mult P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_comp_negate P_((t_handle,t_handle,t_handle *));
extern t_handle glue_comp_norm P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_comp_power P_((t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle*,t_handle *));
extern t_handle glue_comp_precision P_((t_handle,t_handle));
extern t_handle glue_comp_slash P_((t_handle,t_handle,t_handle));
extern t_handle glue_comp_subtract P_((t_handle,t_handle,t_handle,t_handle *));
extern t_int comp_precision P_((t_handle,t_handle));
extern t_logical comp_elt_coerce P_((t_handle,t_handle,t_handle,t_int,t_handle*,t_int*,t_logical));
extern t_logical comp_eq P_((t_handle,t_comp,t_comp));
extern t_logical comp_ne P_((t_handle,t_comp,t_comp));
extern t_real comp_arg P_((t_handle,t_comp));
extern t_real comp_im P_((t_handle,t_comp));
extern t_real comp_modulus P_((t_handle,t_comp));
extern t_real comp_norm P_((t_handle,t_comp));
extern t_real comp_re P_((t_handle,t_comp));
extern t_void comp_cart_to_polar P_((t_handle,mp_float,mp_float,mp_float*,mp_float *));
extern t_void comp_elt_delete P_((t_handle,t_comp *));
extern t_void comp_elt_print P_((t_handle,integer_big));
extern t_void comp_polar_to_cart P_((t_handle,mp_float,mp_float,mp_float*,mp_float *));
extern t_void comp_str_delete P_((t_handle,t_handle *));
extern t_void comp_str_print P_((t_handle,t_handle));
extern t_void comp_write P_((t_handle,t_comp,t_int));

#endif /* _COMP_E_ */
