/*******************************************************************************
                   
anf_thue.h
   
 
History:

*******************************************************************************/
#ifndef INCLUDED_THUE_H
#define INCLUDED_THUE_H

#include "integer.e"
#include "mat.e"
#include "real.e"
#include "dyn_arr.h"
#include "dmat.h"

/*******************************************************************************
/
/  Introducing new types
/
*******************************************************************************/
 
typedef t_handle  thue;
 
/*
    temporarily (until update of block_type.h)
*/
 
#ifndef THUE_BLOCK_TYPE
 
#define THUE_BLOCK_TYPE       1000
 
#endif  THUE_BLOCK_TYPE
        
/******************************************************************************
/ 
/  Structure definition for thue equations
/
*******************************************************************************/

  
typedef struct
	{
		t_block_header	trbl_hdr;

		integer_small	abs_degree;

		vector  	th_coeff;

                integer_big     th_M;

                order           th_ord;

                dyn_arr_handle  th_gamma;
        
                dyn_arr_handle  th_delta;
        
                t_real          th_wald_a0;

                t_real          th_b0;
                
                t_real          th_b1;

                t_real          th_ymax;

                dyn_arr_handle  th_solution_pos;

		dyn_arr_handle	th_solution_neg;

                t_handle        th_R;

                integer_small   th_print_level;

	}
	t_thue_table;

  
/*******************************************************************************
/
/   Macros for accessing structure items of thue equations
/
*******************************************************************************/
  
/*
    access macro for table element (internal use)
*/
    
#define thue_access(h)	((t_thue_table *) mem_access(h))
  
/*
    absolute degree of thue equation 
    t_handle of coefficient vector
*/ 
  
#define thue_abs_degree(h)	(thue_access(h) -> abs_degree)
#define thue_eqn_coeff(h)	(thue_access(h) -> th_coeff)
#define thue_coeff(h, i)	vec_entry(thue_eqn_coeff(h), (i) )
#define thue_coeff_alloc(h)     thue_eqn_coeff(h) = vec_new(thue_abs_degree(h)+1)
#define thue_M(h)               (thue_access(h) -> th_M) 
#define thue_order(h)           (thue_access(h) -> th_ord)
#define thue_gamma(h)           (thue_access(h) -> th_gamma)
#define thue_ith_gamma(h, i)    dyn_arr_element(thue_gamma(h), (i-1) )

#define thue_delta(h)	(thue_access(h) -> th_delta)
#define thue_ith_delta(h, i) \
		dyn_arr_element(thue_delta(h), (i) ) 
#define thue_waldschmidt_a0(h)  (thue_access(h) -> th_wald_a0)
#define thue_B0(h)              (thue_access(h) -> th_b0)
#define thue_B1(h)              (thue_access(h) -> th_b1)
#define thue_ymax(h)            (thue_access(h) -> th_ymax)

#define thue_solution_pos(h)	(thue_access(h) -> th_solution_pos)
#define thue_ith_solution_pos(h, i) \
		dyn_arr_element(thue_solution_pos(h), (i) )
 
#define thue_solution_neg(h)	(thue_access(h) -> th_solution_neg)
#define thue_ith_solution_neg(h, i) \
		dyn_arr_element(thue_solution_neg(h), (i) )

#define thue_reals(h)           (thue_access(h) -> th_R)

#define thue_print_level(h)     (thue_access(h) -> th_print_level)
  
#define thue_incref(h)          block_incref(h)

#endif INCLUDED_THUE_H
