/*  zm.e

Package for integers modulo m.
*/

#ifndef	_ZM_E
#define	_ZM_E

#include "defs.h"
#include "ring.h"
#include "modint.e"

/*
** Structure of the block containing a Zm ring.
*/

typedef struct
	{
		t_ring_common	ring_hdr;

		integer_big	modulus;
		faclst		factors;
	}
	t_zm_table;

/*
** Access to the information in the ring block.
*/

#define zm_access(h)		((t_zm_table *) ring_access(h))
#define zm_modulus(h)		(zm_access(h) -> modulus)
#define zm_factors(h)		(zm_access(h) -> factors)

/*
** Zm ring creation and storage.
*/

#define m_zm_str_incref(r)		(block_incref(r))
#define m_zm_str_delete(r)		zm_str_delete(0,&r)

/* protos */

extern t_logical zm_elt_coerce P_((t_handle,t_handle,t_handle,t_int,t_handle *,t_int *,t_logical));
extern integer_big zm_all_sqrts P_((t_handle,integer_big));
extern integer_big zm_elt_incref P_((t_handle,integer_big));
extern integer_big zm_inverse P_((t_handle,integer_big));
extern integer_big zm_lcm P_((t_handle,t_int,t_int));
extern integer_big zm_order P_((t_handle,t_int));
extern integer_big zm_seq_lcm P_((t_handle,t_handle));
extern integer_big zm_sqrt P_((t_handle,t_handle));
extern t_handle glue_zm_all_sqrts P_((t_handle,t_handle));
extern t_handle glue_zm_characteristic P_((t_handle,t_handle));
extern t_handle glue_zm_hash P_((t_handle,t_handle));
extern t_handle glue_zm_modulus P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_zm_primitive_root P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_zm_random P_((t_handle,t_handle*,t_handle*,t_handle *));
extern t_handle glue_zm_rep P_((t_handle,t_handle*,t_handle*,t_handle *));
extern t_handle glue_zm_sqrt P_((t_handle,t_handle));
extern t_handle zm_add P_((t_handle,t_int,t_int,t_handle *));
extern t_handle zm_div P_((t_handle,t_handle,t_handle));
extern t_handle zm_eq P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle));
extern t_handle zm_gcd P_((t_handle,integer_big,integer_big));
extern t_handle zm_mult P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle zm_negate P_((t_handle,t_handle,t_handle *));
extern t_handle zm_power P_((t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle*,t_handle *));
extern t_handle zm_primitive_root P_((t_handle,t_handle));
extern t_handle zm_seq_gcd P_((t_handle,t_handle));
extern t_handle zm_str_create P_((integer_big, t_handle));
extern t_handle zm_str_incref P_((t_handle,t_handle));
extern t_handle zm_subtract P_((t_handle,t_handle,t_handle,t_handle *));

extern t_logical zm_is_minus_one P_((t_handle,integer_big));
extern t_logical zm_is_primitive P_((t_handle,t_handle));
extern t_logical zm_ne P_((t_handle,t_handle,t_handle));
extern t_logical zm_str_iterator_ctx P_((t_handle,t_logical,t_handle *,t_handle *));
extern t_logical zm_str_iterator_next P_((t_handle,t_handle*,t_handle*,t_int *));
extern t_logical zm_unit P_((t_handle,t_int));
extern t_void zm_elt_delete P_((t_handle,integer_big *));
extern t_void zm_elt_print P_((t_handle,integer_big));
extern t_void zm_hash P_((t_handle,t_int,integer_big *));
extern t_void zm_modulus_f P_((t_handle,t_handle,integer_big *));
extern t_void zm_str_delete P_((t_handle,t_handle *));
extern t_void zm_str_print P_((t_handle,t_handle));

#endif	/* _ZM_E */
