#include "kant.h"  

/*
   Tries to compute a minimal polynomial of a field which contains two
   given fields. Those fields must not have a common subfield. 


Notice !!! : The routine is a kind of quick and dirty tool. Not really 
             debuged and maybe very slow. However, it works for merging 
             fields with small degrees. Whatever it means.  

             There is some intermidiate output of the coefficients, before 
             the field is printed out by order_write. That's for keeping track 
             on the precision by eyes. Very old method!
             

Example:

We want to compute a field that contains the following fields 
as subfields. 

(FLD=)   5,  1,  4,  0,  2,  4,  1,  1,  0,  0,  5, *          14641.,      1.636      
 1 -4 -3 3 1
 0 -3 0 1 0
 -1 2 3 -1 -1
 2 0 -1 0 0
 -2 0 4 0 -1
  C5

(FLD=)   4,  1,  3,  0,  2,  3,  0,  0,  0,  0,  0, *     725   0.825   D8    1
 -1 -3 1 1
 -1 2 1 -1
 0 -1 0 0
 -1 1 0 0

We did this by adding the roots (4 times 5) of each polynomial 
as new zeroes for a polynomial of degree 20.
With the help of  Newton's relations this routine computes
the coefficients of a polynomial when the zeroes are given.
The leading coefficient is assumed to be 1.
The other coefficients are computed recursively via
F(K+1) = -1/K (S(K)+ SUM{I=1 to K-1} F(I+1)S(K-I))
      for K=1,...,N and 
      S(K) := SUM{L=1 to N} ZEROES(*,L)**K.
It is assumed that the polynomial has got integer coefficients.

The result is:
x^20 - x^19 - 34*x^18 + 26*x^17 + 449*x^16 - 264*x^15 - 2975*x^14 + 1378*x^13 + 10689*x^12 - 4084*x^11 - 21107*x^10 + 7078*x^9 + 22190*x^8 - 7047*x^7 - 11568*x^6 + 3849*x^5 + 2662*x^4 - 1056*x^3 - 176*x^2 + 110*x - 11
 
in KANT format
(FLD=)  20, -1,  0,  0,  0,  0,  0,  0,  0,  0, -1, * 
-1 -34 26 449 -264 -2975 1378 10689 -4084 -21107 7078 22190 -7047 -11568 3849 2662 -1056 -176 110 -11 





*********************************************************************************/


void complex_mult WITH_7_ARGS( 

	t_handle,	      R,
	t_handle,	      r1,
	t_handle,	      i1,
 	t_handle,	      r2,
        t_handle,       i2,
	t_handle*,      r3,
	t_handle*,      i3     ) 

/*********************************************************************************

Description: 

	Complex multiplication

Calling sequence: 

    	t_handle	 	R   = reals
	t_handle		r1  = 1. number  RE
	t_handle	  	i1  = 1. number  IM
 	t_handle		r2  = 2. number  RE
        t_handle  	i2  = 2. number  IM
	t_handle*  	r3  = product    RE
	t_handle*    	i3  = product    IM

History:

	92-03-24 JPS written

*********************************************************************************/
{
	block_declarations;

	t_real		temp1, temp2;

        temp1 = real_mult(R, r1, r2);
	temp2 = real_mult(R, i1, i2);
        *r3   = real_subtract(R, temp1, temp2);

	real_delete(&temp1);
	real_delete(&temp2);

	temp1 = real_mult(R, r1, i2);
	temp2 = real_mult(R, r2, i1);
	*i3   = real_add(R, temp1, temp2);

	real_delete(&temp1);
	real_delete(&temp2);
} 


main()
	{
	block_declarations;
        
        t_int           deg, deg1, deg2, precision;
        t_int           i, j, r1, r2, r12;
        t_handle        R, Z;
        t_real          h1, h2;
        order           ord, ord1, ord2;
        vector          p1r, p1i, p2r, p2i, CR, CI, I;
        anf             anf1, anf2; 

	t_poly            pol, pol1, old_pol, pol_dummy1, pol_dummy2, gcd_pol;
        integer_small     poldeg, k, s, l, pointer, m;
	t_real		  tempr, tempi, tempr_old, tempi_old, temp, temp_old; 
        t_real          temp1, temp2;
	t_int		  koeff, int_dummy1, int_dummy2;
        Logical           exit;    



	kant_start();

        order_read(&ord1);
        order_read(&ord2);  
        deg1 = order_abs_degree(ord1);
        deg2 = order_abs_degree(ord2);
        order_reals_create(ord1);
        order_reals_create(ord2);
        anf1 = order_anf(ord1);
        anf2 = order_anf(ord2);
        R = order_reals(ord1);
        

        p1r = vec_new(deg1);
        p1i = vec_new(deg1);
        p2r = vec_new(deg2);
        p2i = vec_new(deg2);

        r1 = order_r1(ord1);
        r2 = order_r2(ord1);
        r12 = r1 + r2;
	for (i=1; i<=r1; ++i)
		{
  		vec_entry(p1r, i) = real_incref(anf_poly_z_zero(anf1, 1, i));
                vec_entry(p1i, i) = ring_zero(R);
		}      
	for (i=r1+1; i<=r12; ++i)
		{
		vec_entry(p1r, i)    = real_incref(anf_poly_z_zero(anf1, 1, i));
		vec_entry(p1r, i+r2) = real_incref(anf_poly_z_zero(anf1, 1, i)); 
		vec_entry(p1i, i)    = real_incref(anf_poly_z_zero(anf1, 1, i+r2));
		vec_entry(p1i, i+r2) = real_negate(R, anf_poly_z_zero(anf1, 1, i+r2));
		}	                                   
        r1 = order_r1(ord2);
        r2 = order_r2(ord2);
        r12 = r1 + r2;
	for (i=1; i<=r1; ++i)
		{
  		vec_entry(p2r, i) = real_incref(anf_poly_z_zero(anf2, 1, i));
                vec_entry(p2i, i) = ring_zero(R);
		}      
	for (i=r1+1; i<=r12; ++i)
		{
		vec_entry(p2r, i)    = real_incref(anf_poly_z_zero(anf2, 1, i));
		vec_entry(p2r, i+r2) = real_incref(anf_poly_z_zero(anf2, 1, i)); 
		vec_entry(p2i, i)    = real_incref(anf_poly_z_zero(anf2, 1, i+r2));
		vec_entry(p2i, i+r2) = real_negate(R, anf_poly_z_zero(anf2, 1, i+r2));
		}
        
        deg = deg1 * deg2;
        CR = vec_new(deg);
        CI = vec_new(deg);
        I  = vec_new(deg);

        for (i=1; i<=deg1; i++)
                {
                for (j=1; j<=deg2; j++)
                        {
                        h1 = vec_entry(p1r, i);
                        h2 = vec_entry(p2r, j);
                        vec_entry(CR, deg1*(j-1)+i) = real_add(R, h1, h2);
                        h1 = vec_entry(p1i, i);
                        h2 = vec_entry(p2i, j);
                        vec_entry(CI, deg1*(j-1)+i)= real_add(R, h1, h2);
                        }
                }

	Z = m_z_str_incref(structure_z);
	m_poly_u_create_empty(&pol, deg+1);

	for (k=1; k<=deg; ++k)
		{
                printf("k=%d\n",k);
		temp = ring_zero(R);
		for (l=1; l<=k; ++l)
			vec_entry(I, l) = l;
		exit = FALSE;
		pointer = k;	                        
		do
			{
			tempr = conv_int_to_real(R, 1);
			tempi = ring_zero(R);   	
			for (j=1; j<=k; ++j)                            
				{
				tempr_old = tempr;
				tempi_old = tempi;
				complex_mult( R,
					      vec_entry(CR,
							vec_entry(I, j)),
					      vec_entry(CI,
							vec_entry(I, j)),		      	
       	                                      tempr,
       	   				      tempi,
          				      &tempr,
       	   				      &tempi
       	   			   	    ); 
				real_delete(&tempr_old);
				real_delete(&tempi_old);
				}
			temp_old = temp;
			temp = real_add(R, temp, tempr);
    	   		real_delete(&temp_old);
			m = vec_entry(I, pointer);
			++m;
			if (m>deg-k+pointer)
				{
				do        
					{
					--pointer;
					if (pointer == 0) exit = TRUE;	
					}
				while ( (vec_entry(I, pointer) >= deg-k+pointer) && (!exit));
          			++vec_entry(I, pointer);
          			for(l=1; l<=k-pointer; ++l)
        				vec_entry(I, l+pointer)=vec_entry(I, pointer) + l;
				pointer = k;
				}
			else	 
                             	{
				vec_entry(I, pointer) = m;
				} 
			real_delete(&tempr);
			real_delete(&tempi);
                        }
   		while (!exit);
                real_write(R, temp, 20);puts("");
                koeff = conv_real_to_int_round(R, temp);
		real_delete(&temp);
		s= (k&1) ? -1 : 1 ;
		m_poly_coefft(pol, deg-k) = integer_mult(koeff, s);
                m_poly_expt(pol, deg-k) = deg-k; 
		integer_delete(&koeff);
		}		
        m_poly_coefft(pol, deg) = 1;
	m_poly_expt(pol, deg) = deg;
	vec_delete(R, &CR);                     
 	vec_delete(R, &CI);
	vec_delete(Z, &I);

	old_pol = pol;
	pol = poly_z_clean(structure_pring_z, m_poly_handle_to_poly(pol));
        m_poly_z_delref(structure_pring_z, old_pol);
        
        puts("Summe:");
        poly_z_write(Z, pol); puts("");
        ord = order_equation_create(Z, pol);
        order_write(ord);

}          
