#include "kant.h"
 
main()  
/*******************************************************************************
 
   minpoly_shortest.c
 
   JS April 1992
 
   Computes a better minimal polynomial for the number field given by
   the order.
   
History:
 
	92-07-06 JS    lll reduction of order, maximal order
	92-04-22 JS    order_write
	92-04-01 JS    first version
 
*******************************************************************************/
{
	block_declarations;         
         
	order		ord, ordmax, ordl, ordeq, Z;
        anf_elt	        alphal, alpha; 
        t_poly       pol;

	kant_start();
 
        Z = m_z_str_incref(structure_z);

	while(order_read(&ord))
	{              
                order_disc_assure(ord);
                cay_print("Discriminant of input order: %d\n", order_disc(ord));
 
		ordmax = order_maximal(ord);
                puts("Maximal order:"); order_write(ordmax);
                ordl    = order_lll_reduce(ordmax);
 
                alphal = order_shortest_primitive_elt(ordl);
                alpha  = anf_elt_move(ordl, alphal, ordmax);
  
                puts("Algebraic number (referring to basis of maximal order): "); 
                anf_elt_write(ordmax, alpha); puts("");                                               
 
                pol   = anf_elt_minpoly(ordmax, alpha);
                printf("Minimal polynomial: "); poly_z_write(structure_pring_z, pol); puts("");
       
                ordeq = order_equation_create(Z, pol);
                order_disc_assure(ordeq);
 
                puts("... and written as equation order:");
                order_write(ordeq);

                m_poly_z_delref(structure_pring_z, pol);
                anf_elt_delete(ordmax,  &alpha);
                anf_elt_delete(ordl, &alphal);

 		order_delete(&ordl);
 		order_delete(&ord);
 		order_delete(&ordmax);
 		order_delete(&ordeq);
        }
 
	ring_delete(&Z);
}
