//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : debug.h 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Feb 7 1995, initial version
//

#ifndef LIDIA_DEBUG_H
#define LIDIA_DEBUG_H

typedef void (*debug_handler_ptr)(char *, char *);

extern debug_handler_ptr lidia_debug_handler;
extern void default_debug_handler(char *, char *);
extern debug_handler_ptr set_debug_handler(debug_handler_ptr);

#ifdef LIDIA_DEBUG
#define debug_handler(name, message) lidia_debug_handler(name, message)
#define debug_handler_l(name, message, level) { if (LIDIA_DEBUG <= level)\
			              lidia_debug_handler(name, message); }

#define debug_handler_c(name, message, level, code) { if (LIDIA_DEBUG <= level)\
			        { lidia_debug_handler(name, message); code; }}
#else
#define debug_handler(name, message) { }
#define debug_handler_l(name, message, level) { }
#define debug_handler_c(name, message, level, code) { }
#endif

#endif
