//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : error.c 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Feb 7 1995, initial version
//

#include <LiDIA/lidia.h>
#include <stdlib.h>

void default_error_handler(const char *f, const char *m)
{
  cout << "\n error_handler";
  cout << "::" << f;
  cout << "::" << m;
  cout << "\n";
  cout.flush();
  abort();
}

error_handler_ptr lidia_error_handler = default_error_handler;

error_handler_ptr set_error_handler(error_handler_ptr new_handler)
{
  error_handler_ptr old_handler = lidia_error_handler;
  lidia_error_handler = new_handler;
  return old_handler;
}
