.TH FMIN L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.hy 0
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST *
.tr ^\|
.tr ~
.SH NAME
FMIN
.SH DECLARATIONS
.nf
double precision function FMIN(a,b,F,tol)
double precision a, b, F, tol
.fi
.SH SYNOPSIS
.PP
FORTRAN function that returns the
local minimum of a single-valued function
on a given interval.  FMIN was taken from Forsythe, Malcolm,
and Moler[1].
.PP
FMIN uses is a combination of  golden  section  search  and
successive parabolic interpolation.  Convergence is never much slower
than that for a Fibonacci search.  If \fIF\fR has a continuous second
derivative which is positive at the minimum (which is not at \fIa\fR or
\fIb\fR), then convergence is superlinear, and usually of the order of
about 1.324....
.SH PARAMETERS
.TP 8
a,b
Left and right endpoints, respectively, of initial interval.
.TP 8
F
The name of the function subprogram defining \fIF(x)\fR.  This program
should have the form:
.RS
.ns
.IP
.nf
double precision function F(x)
double precision x
F = ...
return
end
.RE
.fi
.IP
The function name \fIF\fR must be declared in an EXTERNAL statement
in the calling program.
.TP 8
tol
Desired length of the interval of uncertainty of the final
result ( .ge. 0.0d0).
The function \fIF\fR is never evaluated at two points closer together
than \fIeps*abs(FMIN)~+~(tol/3)\fR, where \fIeps\fR is
approximately the square root of the relative machine precision.
FMIN approximates a minimum of the interval with an an error
less than \fI3*eps*abs(fmin)~+~tol\fR.
.SH DETAILS
If the function \fIF\fR is a unimodal
over the interval [\fIa,b\fR],
then FMIN approximates the global minimum of \fIF\fR
on the interval.
If \fIF\fR is not unimodal over the interval,
then FMIN may approximate a local, but perhaps non-global, minimum.
.PP
FMIN finds a minimum by iteratively reducing the interval
containing this minimum.  Specifically,
two points, \fIx1\fR and \fIx2\fR, are chosen from
within the interval [\fIa,b\fR], i.e.,
\fIa\fR~<~\fIx1\fR~<~\fIx2\fR~<~\fIb\fR.  If \fIF(x1)\fR <= \fIF(x2)\fR,
the new interval is [\fIa,x2\fR], otherwise, \fIF(x2)\fR <= \fIF(x1)\fR
and the new interval is [\fIx1,b\fR].
The choice of \fIx1\fR and \fIx2\fR is made by either the 
golden section search or parabolic interpolation, the method
being determined at each iteration within the subroutine. 
.SH EXAMPLE
.if t .ta .13i .5i 1i
.if n .ta 3 7 14
.nf
C	Sample program for FMIN
C
		double precision function F(x)
		double precision x
		F = x*(x*x -2.d0) -5.d0
		return
		end
C
		external F
		double precision a,b,z,tol,fmin
		a = 0.d0
		b = 1.d0
		tol = 1.0d-5
		z = fmin(a,b,F,tol)
		write(6,*) z
		end
.fi
.SH REFERENCES
.IP [1]
Forsythe, G. E., M. A. Malcolm, C. B. Moler, \fBComputer Methods
for Mathematical Computations\fR. Prentice-Hall, Inc., 1977.
.SH FURTHER INFORMATION
.nf
Contact:
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM  87131
