.TH RQUAD L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.hy 0
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST *
.tr ^\|
.tr ~
.SH NAME
RQUAD
.SH DECLARATIONS
.nf
double precision function rquad(F,a,b,abserr,ok)
external F
double precision a, b, abserr
logical ok
.fi
.SH SYNOPSIS
FORTRAN function
to estimate the definite integral of \fIF(t)\fR from \fIa\fR to \fIb\fR
using an adaptive quadrature scheme based on Gauss-8 rule.
This routine was based on an algorithm by Ron Jones of Sandia
Laboratories and was written by Cleve Moler and Henry Shapiro
of UNM.
.PP
This routine works best on a function that is
reasonably smooth within the
interval.  That is, functions with singularities, discontinuities,
narrow spikes, etc, may not be evaluated correctly or may
result in an error condition in the procedure.
.PP
For more information regarding quadrature see Forsythe[2] or Allen[1].
The QUADPACK[3] manual provides an extensive discussion on quadrature
along with routines for solving a large variety of problems.
.SH PARAMETERS
.TP 10
F
The name of the function subprogram defining \fIF(x)\fR.  This program
should have the form:
.RS
.ns
.IP
.nf
double precision function F(x)
double precision x
F = ...
return
end
.RE
.fi
.IP
The function name \fIF\fR must be declared in an EXTERNAL statement
in the calling program.
.TP 10
a, b
The end points of the integration interval, \fIa\fR~<~\fIb\fR.
.TP 10
abserr
Tolerance requested for integral over interval \fI(a,b)\fR.
.TP 10
ok
Flag returned that indicates success or failure of rquad.
If the desired accuracy cannot be achieved
in a reasonable number of steps, or because roundoff
error intervenes, or the stack depth is exceeded
(unlikely) the global variable ok is set to false.
.SH DETAILS
RQUAD uses the Gauss 8 rule for approximating the integral over
an interval.
An advantage of a Gaussian rule is that the function is not
evaluated at the end points.
.PP
The estimated error is determined
by comparing the integral of a given interval with the sum
of the integrals of the two halfs of that interval.  It must
be remembered that the
requested error tolerance, \fIabserr\fR, is the error over
the entire interval \fIa\fR to \fIb\fR.  Thus, the error
over each sub-interval is a fraction of \fIabserr\fR.
Very small values for \fIabserr\fR is not recommended.
.PP
An adaptive algorithm is one that automatically choses the size of
interval sub-divisions and creates more sub-divisions in
regions where the integration is more difficult, and fewer
sub-divisions where the function is smoothest.
RQUAD essentially uses a recursive algorithm to sub-divide the
interval.  That is, it uses a stack to store the sub-intervals and
sub-divides the interval in a left-right, or depth-first, fashion.
.SH EXAMPLE
.nf
.if t .ta .13i .5i 1i
.if n .ta 3 7 14
C		Sample driver for RQUAD
C
		EXTERNAL F
		DOUBLE PRECISION A,B,ABSERR,ANSWER
		LOGICAL OK
		A = 0.0D0
		B = 1.0D0
		ABSERR = 0.0D0
		ANSWER = RQUAD(F,A,B,ABSERR,OK)
		IF (OK) THEN
			WRITE(6,10) ANSWER
	10		FORMAT('    ANSWER=',E24.15)
		ELSE
			WRITE(6,20)
	20		FORMAT('    INTEGRATION NOT COMPLETED')
		ENDIF
		STOP
		END
C
		DOUBLE PRECISION FUNCTION F(X)
		DOUBLE PRECISION X
		F = DEXP(X)
		RETURN
		END
.nf
.fi
.SH SEE ALSO
KQUAD
.SH REFERENCES
.fi
.IP [1]
Allen R., Pruess S., Shampine L., \fBNumerical Computing\fR,
Math 375 Class Notes, 1984-85.  (To be published)
.IP [2]
Forsythe, G. E., M. A. Malcolm, C. B. Moler, \fBComputer Methods
for Mathematical Computations\fR. Prentice-Hall, Inc., 1977.
.IP [3]
Piessens, R., E. de Doncker-Kapenga, C. W. Uberhuber, D. K. Kahaner,
\fBQUADPACK, A Subroutine Package for Automatic Integration\fR,
Springer-Verlag, 1983.
.IP [4]
Shapiro, H., \fIIncreasing Robustness in Global Adaptive Quadrature
Through Interval Selection Heuristics\fR, Department of Computer
Science, College of Engineering, University of New Mexico,
Technical Report CS82-3, 1982.
.SH FURTHER INFORMATION
.nf
Contact:
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM  87131
