.TH SPCOEF L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.hy 0
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST *
.tr ^\|
.tr ~
.SH NAME
SPCOEF, SVALUE
.SH DECLARATIONS
.nf
subroutine SPCOEF(n,x,y,b,c,d,iflag)
integer n,iflag
double precision x(n),y(n),b(n),c(n),d(n)

subroutine SVALUE(n,x,y,b,c,d,t,s,iflag)
integer n,iflag
double precision x(n),y(n),b(n),c(n),d(n),t,s
.fi
.SH SYNOPSIS
.PP
FORTRAN subroutines for
computing cubic interpolatory splines.
SPCOEF calculates the coefficients for the cubic interpolatory spline.
SVALUE evaluates the spline at a point using the coefficients from SPCOEF.
.PP
For each problem, SPCOEF is called once, then 
SVALUE can be called any number of times to
determine the value of the spline at various
points.
No changes must be made in the parameters used by SPCOEF
between subsequent calls to SVALUE.
.PP
These routines were taken from the text by Allen, Pruess, 
and Shampine[1].
Further discussion of 
cubic splines can be found in de Boor[2] and Forsythe[3].
.SH PARAMETERS
.TP 10
n
Number of data points.
.TP 10
x(n)
Vector of values of the independent variable.  It
is assumed that \fIx(i) < x(i+1)\fR for all \fIi\fR.
.TP 10
y(n)
Vector of values of the dependent variable; \fIy(i) = f(x(i))\fR.
.TP 10
b(n)
Vector of first derivatives of the spline function \fIs\fR; \fIb(i)~=~s'(x((i))\fR.
.TP 10
c(n)
Vector of second derivative information of \fIs\fR; \fIc(i)~=~s''x((i))/2\fR.
.TP 10
d(n)
Vector of third derivative information of \fIs\fR; \fId(i)~=~s'''x((i))/6\fR.
.TP 10
t
Point where spline is to be evaluated
.TP 10
s
Value of spline at \fIt\fR
.TP 10
iflag
Indicator of error conditions.
SPCOEF returns flags 0, -1, and -2 only. SVALUE returns
flags 0, 1, -1 and 2 only.
.RS
.IP " 0"
normal return
.IP "-1"
\fIn\fR <= 1
.IP "-2"
\fIx\fR vector is incorrectly ordered, \fIx(i+1) >= x(i)\fR for
some \fIi\fR
.IP " 1"
\fIt < x(1)\fR
.IP " 2"
\fIt > x(n)\fR
.RE
.SH DETAILS
.PP
The cubic spline used in these routines is uniquely determined
in the following manner.  Let
\fIc1(x)\fR and \fIcN(x)\fR be the unique cubics which pass
through the first four and the last four data points, respectively.
The code specifies the end conditions
such that the first derivatives of the
spline function, \fIs(x)\fR, are matched
to the first derivatives of these cubics; i.e.,
\fIs'(x1) = c1'\fR and \fIs'(xN) = cN'\fR
.SH EXAMPLES
.if t .ta .13i .5i .75i
.if n .ta 3 7 11
.nf
C		SAMPLE PROGRAM
C
		DOUBLE PRECISION X(10),Y(10),B(10),C(10),D(10)
		DOUBLE PRECISION S,T,STEP
		INTEGER N,IFLAG
C
		N = 6
		STEP = 0.2D0
		T = 0.0D0
		DO 10 I = 1,N
			X(I) = I
			Y(I) = X(I)**3
			T = T + STEP
	10	CONTINUE
C
		CALL SPCOEF(N,X,Y,B,C,D,IFLAG)
C
		STEP = 0.1d0
		T = 0.0D0
		DO 20 I = 1,11
			CALL SVALUE(N,X,Y,B,C,D,T,S,IFLAG)
			WRITE(6,30) T, S
			T = T + STEP
	20	CONTINUE
	30	FORMAT(F10.2,F10.6)
		END
.fi
.SH REFERENCES
.IP [1]
Allen R., Pruess S., Shampine L., \fBNumerical Computing\fR,
Math 375 Class Notes, University of New Mexico, 1984-85.
(To be published)
.IP [2]
de Boor, \fRPractical guide to Splines\fR, Springer, NY, 1978.
.IP [3]
Forsythe, G. E., M. A. Malcolm, C. B. Moler, \fBComputer Methods
for Mathematical Computations\fR. Prentice-Hall, Inc., 1977.
.SH FURTHER INFORMATION
.nf
Contact:
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM  87131
