.TH ZERO L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual" 
.hy 0 
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST *
.tr ^\|
.tr ~
.SH NAME
ZERO
.SH DECLARATIONS
.nf
subroutine ZERO(F,a,b,abserr,relerr,iflag,nf)
double precision F,a,b,abserr,relerr
integer iflag,nf
.fi
.SH SYNOPSIS
.PP
FORTRAN subroutine to compute a root of the nonlinear equation
\fIF(x)\fR~=~\fI0\fR where \fIF(x)\fR is a continuous real function
of a single real variable \fIx\fR.
.PP
The method used is a combination of bisection and the secant rule.
Zero was taken from the text by Allen, Pruess, and Shampine[1] and is
based on the algorithm described by Dekker[2].
An alternate discussion of root finding can be found in Forsythe[3].
.SH PARAMETERS
.TP 10
F
The function sub-program defining \fIF(x)\fR.  The declaration for
\fIF\fR should have the form:
.RS
.ns
.IP
.nf
double precision function F(x)
double precision x
F = ...
return
end
.fi
.RE
.IP
The function name \fIF\fR must appear in an external statement
in the calling program.
.TP 10
a,b
On input, these are the initial values of \fIx\fR
such that \fIF(a)\*(STF(b)\fR <= 0.
On output, if no error conditions occurred, \fIa\fR 
is within the error tolerance of a root of \fIF\fR,
\fIb\fR is not relevant.
Otherwise,
\fIa\fR and \fIb\fR
may contain information regarding the error condition
that was encountered, see \fIiflag\fR.
The point \fIa\fR is always selected
so that \fI|F(a)^| <= |F(b)^|\fR.
.TP 10
abserr
.br
.ns
.TP 10
relerr
The absolute and relative error tolerances.
.hy 0
The stopping criterion is: \fI|a-b^|~<=~2.0*max(abserr,~|a^|*relerr)\fR.
.TP 10
nf
The number of function evaluations.
.TP 10
iflag
Error return indicator.
.RS
.IP 0
normal return; \fIF(a)*F(b)~<=~0\fR and the
stopping criterion is met. 
.IP 1
\fIF(a)=0; a,b\fR may not satisfy the stopping criterion.
.IP 2
\fIa\fR is too close to \fIb: float(a+|a-b^|)~=~a\fR.
.IP 3
\fI|F(root)^|\fR exceeds \fImax(|F(a)^|,|F(b)^|)\fR
for the input values of \fIa\fR and \fIb\fR;
in this case it is likely that \fIa\fR is close
to a pole of \fIF\fR.
.IP 4
no odd order zero was found in the interval; a local minimum
may have been obtained.
.IP 5
too many function evaluations were made; 500 are allowed.
.IP -1
invalid input parameters: \fIabserr\fR and \fIrelerr\fR
both zero; \fIabserr\fR or \fIrelerr\fR less than 0.
.RE
.SH DETAILS
ZERO uses the fact that given a function of \fIx, F(x),\fR continuous over
an interval, if points \fIa\fR and \fIb\fR within that interval can be chosen
such that \fIF(a)\*(STF(b)~<~0\fR, then at least one
root of \fIF(x)\fR is contained in the interval \fI(a,b).\fR
ZERO uses a combination of bisection and the secant rule to find a root.
.SH EXAMPLE
.if t .ta .13i .38i .5i 1i
.if n .ta 3 6 7 14
.nf
C			SAMPLE PROGRAM
C
C			FUNCTION DECLARATION 
C
			DOUBLE PRECISION FUNCTION F(X) 
			DOUBLE PRECISION X 
			F = X*(X*X - 2.D0) - 5.0D0
			RETURN
			END
C
C			MAIN PROGRAM
C
			EXTERNAL F
			DOUBLE PRECISION F,A,B,ABSERR,RELERR 
			INTEGER IFLAG,NF
			A = 2.D0
			B = 3.D0
			ABSERR = 0.D0
			RELERR = 1.D0-10
			CALL ZERO(F,A,B,ABSERR,RELERR,IFLAG,NF)
			IF (IFLAG .NE. 0) WRITE(6,10) IFLAG
	10		FORMAT('ERROR CONDITION ',I2)
			IF (IFLAG .EQ. 0) WRITE(6,20) A, NF
	20		FORMAT('ROOT AT ',F15.10,' TOOK ',I4,' FUNCTION EVALUATIONS')
			END
.fi
.SH SEE ALSO
FMIN
.SH REFERENCES
.fi
.IP [1]
Allen R., Pruess S., Shampine L., \fBNumerical Computing\fR,
Math 375 Class Notes, University of New Mexico, 1984-85.
(To be published)
.sp
IP [2]
Dekker, T.S., \fIFinding a zero by means of successive linear
interpolation\fR, \fBConstructive Aspects of the Fundamental 
Theorem of Algebra\fR, B. Dejon and P. Henrici, eds.,
Wiley-Interscience, London, 1969.
.sp
.IP [3]
Forsythe, G. E., M. A. Malcolm, C. B. Moler, \fBComputer Methods
for Mathematical Computations\fR. Prentice-Hall, 1977.
.SH FURTHER INFORMATION
.nf
Contact:
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM  87131
