      SUBROUTINE DSYEV (A,LDA,N,D,X,WORK,JOB,INFO)
      INTEGER LDA,N,JOB,INFO
      DOUBLE PRECISION A(LDA,*),D(*),X(LDA,*),WORK(*)
C
C     DSYEV, Double precision SYmmetric Eigenvales and Vectors.
C     DSYEV computes the eigenvalues and, optionally, the eigenvectors
C     of a real symmetric matrix.
C
C     ON ENTRY
C
C        A       DOUBLE PRECISION (LDA,N)
C                The symmetric matrix.
C                Only the diagonal and lower triangle need be supplied.
C
C        LDA     INTEGER
C                The leading dimension of the arrays A and X.
C
C        N       INTEGER
C                The order of the matrices A and X.
C
C        JOB     INTEGER
C                = 0  Eigenvalues only.
C                = 1  Eigenvalues and eigenvectors.
C
C        WORK    DOUBLE PRECISION (N or 3*N)
C                WORK is a scratch array.
C                If JOB = 0, the dimension must be at least N.
C                If JOB > 0, the dimension must be at least 3*N..
C
C     ON RETURN
C
C        A       The diagonal and lower triangle have been altered.
C                The strict upper triangle is unchanged, unless it
C                has been overwritten by X.
C
C        D       DOUBLE PRECISION (N)
C                The eigenvalues, in decreasing order.
C
C        X       DOUBLE PRECISION (LDA,N)
C                X(:,J) is an eigenvector associated with D(J).
C                The matrix of eigenvectors is orthogonal.
C                X and A may be the same array, in which case the
C                eigenvectors overwrite the input array.
C
C        INFO    INTEGER
C                = 0, usual case, results are accurate.
C                = nonzero, results may be inaccurate, see below.
C
C     In rare situations associated with underflow, the output value 
C     of INFO may be a nonzero value, M, indicating that the iteration 
C     for the M-th eigenvalue did not converge satisfactorily.  This is 
C     a warning that the computed eigenvalues D(1) through D(M) may be 
C     inaccurate.  Better results might be obtained by multiplying the 
C     matrix by a huge scale factor, say 1.0E30, computing the 
C     eigenvalues again, and then dividing the computed eigenvalues by 
C     the scale factor.
C
C     EISPACK 8X. This version dated 08/04/84 .
C     Cleve Moler, University of New Mexico.
C
C  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
C     Householder reduction to tridiagonal form.
C     Store the diagonal in D and the offdiagonal in WORK.
C
      CALL DSYTRE (A,LDA,N,D,WORK)
C
C     If requested, accumulate the transformations in X.
C
      IF (JOB .GT. 0) CALL DSYACM (A,LDA,N,X)
C
C     Tridiagonal QR iteration to find the eigenvalues.
C     Accumulate the transformations if requested.
C
      CALL DSYTQR (D,WORK,N,X,LDA,WORK(N+1),JOB,INFO)
C
      RETURN
      END
