      SUBROUTINE DSYTRE (A,LDA,N,D,E)
      INTEGER LDA,N
      DOUBLE PRECISION A(LDA,*),D(*),E(*)
C
C     DSYTRE, Double precision SYmmetric Tridiagonal REduction.
C     DSYTRE reduces a real symmetric matrix to tridiagonal form.
C
C     ON ENTRY
C
C        A       DOUBLE PRECISION (LDA,N)
C                The symmetric matrix.
C                Only the diagonal and lower triangle need be supplied.
C
C        LDA     INTEGER
C                The leading dimension of the array  A .
C
C        N       INTEGER
C                The order of the matrix  A .
C
C     ON RETURN
C
C        A       The diagonal and lower triangle contain information
C                about the transformations that can be used by DSYACM.
C                The upper triangle is unaltered.
C
C        D       DOUBLE PRECISION (N)
C                The diagonal of the symmetric tridiagonal result.
C
C        E       DOUBLE PRECISION (N)
C                The offdiagonal of the result, E(2) through E(N).
C
C     EISPACK 8X. This version dated 06/12/84 .
C     Cleve Moler, University of New Mexico.
C
C  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

C
      DOUBLE PRECISION ALPHA,BETA,GAMMA,DNRM2
      INTEGER I,J,K
C
      D(1) = A(1,1)
      DO 80 K = 2, N-1
C
C        Use a Householder reflection to zero a(i,k-1), i = k+1,..., n .
C        Let  a = (0, ..., 0, a(k,k-1) ... a(n,k-1))',
C             u =  a/norm(a) + (k-th unit vector),
C             beta = -u(k) = -norm(u)**2/2 ,
C             H = I + u*u'/beta .
C        Replace  A  by  H*A*H .
C
         ALPHA = DNRM2(N-K+1,A(K,K-1),1)
         IF (A(K,K-1) .LT. 0.0D0) ALPHA = -ALPHA
C
C        Do the transformation only if the column is nonzero.
C
         IF (ALPHA .NE. 0.0D0) THEN
C
C           Store u in D(K) through D(N) .
C
            DO 10 I = K, N
               D(I) = A(I,K-1)/ALPHA
   10       CONTINUE
            D(K) = D(K) + 1.0D0
            BETA = -D(K)
C
C           Symmetric matrix times vector,  v = A*u.
C           Store  v  in  E(K) through E(N) .
C
            DO 15 I = K, N
               E(I) = 0.0D0
   15       CONTINUE
            DO 30 J = K, N
               E(J) = E(J) + A(J,J)*D(J)
               DO 20 I = J+1, N
                  E(I) = E(I) + A(I,J)*D(J)
                  E(J) = E(J) + A(I,J)*D(I)
   20          CONTINUE
   30       CONTINUE
C
C           v = v/beta
C           gamma = v'*u/(2*beta)
C           v = v + gamma*u
C
            DO 34 I = K, N
               E(I) = E(I)/BETA
   34       CONTINUE
            GAMMA = 0.0D0
            DO 38 I = K, N
               GAMMA = GAMMA + E(I)*D(I)
   38       CONTINUE
            GAMMA = GAMMA/(2.0D0*BETA)
            DO 40 I = K, N
               E(I) = E(I) + GAMMA*D(I)
   40       CONTINUE
C
C           Rank two update of A, compute only lower half.
C           A  =  A + u'*v + v'*u  =  H*A*H
C
            DO 60 J = K, N
               DO 50 I = J, N
                  A(I,J) = A(I,J) + (D(I)*E(J) + E(I)*D(J))
   50          CONTINUE
   60       CONTINUE
C
C           Save  u  for possible use by DSYACM.
C
            DO 70 I = K, N
               A(I,K-1) = D(I)
   70       CONTINUE
C
         ENDIF
C
C        Pick off the resulting tridiagonal elements.
C
         D(K) = A(K,K)
         E(K) = -ALPHA
   80 CONTINUE
C
      D(N) = A(N,N)
      IF (N .GT. 1) E(N) = A(N,N-1)
      RETURN
      END
