C
C      ________________________________________________________
C     |                                                        |
C     |    COMPUTE AN EIGENVALUE OF LARGEST MODULUS AND THE    |
C     |    CORRESPONDING EIGENVECTOR USING THE POWER METHOD    |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         X     --COMPLEX ARRAY CONTAINING STARTING GUESS|
C     |                 FOR THE EIGENVECTOR SPACE              |
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |         NDIGIT--DESIRED NUMBER OF CORRECT DIGITS       |
C     |                                                        |
C     |         LIMIT --MAXIMUM NUMBER OF ITERATIONS           |
C     |                                                        |
C     |         MULT  --NAME OF SUBROUTINE TO MULTIPLY MATRIX A|
C     |                 BY VECTOR (NAME EXTERNAL IN MAIN PROG.)|
C     |                 MULT(P,V) STORES IN P THE PRODUCT AV   |
C     |                 WHERE P AND V ARE COMPLEX ARRAYS       |
C     |                                                        |
C     |         W     --COMPLEX WORK ARRAY WITH N ELEMENTS     |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         X     --EIGENVECTOR                            |
C     |                                                        |
C     |         E     --COMPLEX VARIABLE CONTAINING THE EIGEN- |
C     |                 VALUES                                 |
C     |                                                        |
C     |         DIF   --INPUT FOR SUBROUTINE WHATIS            |
C     |                                                        |
C     |         SIZE  --INPUT FOR SUBROUTINE WHATIS            |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: CONJG                            |
C     |    PACKAGE FUNCTIONS: MAG,SQ                           |
C     |________________________________________________________|
C
      SUBROUTINE CPOWER(E,X,N,DIF,SIZE,NDIGIT,LIMIT,MULT,W)
      REAL DIF,MAG,R,S,SIZE,SQ,T
      COMPLEX X(1),W(1),E,U,V,Y
      INTEGER I,J,L,LIMIT,N,NDIGIT
      T = 0.
      DO 10 I = 1,N
           S = MAG(X(I))
10         IF ( S .GT. T ) T = S
      IF ( T .NE. 0. ) GOTO 20
      WRITE(6,*) 'STARTING GUESS FOR SUBROUTINE CPOWER CANNOT BE ZERO'
      STOP
20    T = 1./T
      DO 30 I = 1,N
30         W(I) = T*X(I)
      R = 10.**(-NDIGIT)
      L = 0
C     -----------------------------------
C     |*** NORMALIZE STARTING VECTOR ***|
C     -----------------------------------
40    L = L + 1
      DO 50 I = 1,N
50         X(I) = W(I)
C     -------------------------
C     |*** START ITERATION ***|
C     -------------------------
      CALL MULT(W,X)
      T = 0.
      DO 60 I = 1,N
           S = MAG(W(I))
           IF ( S .LE. T ) GOTO 60
           T = S
           J = I
60    CONTINUE
      IF ( T .EQ. 0. ) GOTO 110
      V = 1./W(J)
      U = (0.,0.)
      IF ( MAG(X(J)) .NE. 0. ) U = 1./X(J)
      DIF = 0.
      DO 70 I = 1,N
           Y = X(I)*U
           W(I) = W(I)*V
70         DIF = DIF + MAG(W(I)-Y)
      IF ( DIF .LE. R ) GOTO 100
      IF ( L .LT. LIMIT ) GOTO 40
      SIZE = 3*L + 2
80    E = (0.,0.)
      T = 0.
      DO 90 I = 1,N
           E = E + CONJG(X(I))*W(I)
           T = T + SQ(X(I))
90         X(I) = W(I)
      E = E/(T*V)
      SIZE = 3*L + 2
      RETURN
100   SIZE = 3*L + 1
      GOTO 80
110   E = (0.,0.)
      SIZE = 3*L + 1
      DO 120 I = 1,N
120        X(I) = W(I)
      RETURN
      END
C%
      FUNCTION SQ(A)
      COMPLEX A,B
      REAL C(2)
      EQUIVALENCE (B,C)
      B = A
      SQ = C(1)**2 + C(2)**2
      RETURN
      END
