C
C      ________________________________________________________
C     |                                                        |
C     |                INVERT A COMPLEX MATRIX                 |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         V     --COMPLEX ARRAY CONTAINING MATRIX        |
C     |                                                        |
C     |         LV    --LEADING (ROW) DIMENSION OF ARRAY V     |
C     |                                                        |
C     |         N     --DIMENSION OF MATRIX STORED IN ARRAY V  |
C     |                                                        |
C     |         W     --WORK ARRAY WITH AT LEAST N-1 ELEMENTS  |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         V     --INVERSE                                |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: CABS                             |
C     |________________________________________________________|
C
      SUBROUTINE CVERT(V,LV,N,W)
      COMPLEX V(LV,1),Y,Z
      REAL W(1),S,T
      INTEGER I,J,K,L,M,N,P
      IF ( N .EQ. 1 ) GOTO 110
      L = 0
      M = 1
10    IF ( L .EQ. N ) GOTO 90
      K = L
      L = M
      M = M + 1
C     ---------------------------------------
C     |*** FIND PIVOT AND START ROW SWAP ***|
C     ---------------------------------------
      P = L
      S = CABS(V(L,L))
      IF ( M .GT. N ) GOTO 30
      DO 20 I = M,N
           T = CABS(V(I,L))
           IF ( T .LE. S ) GOTO 20
           P = I
           S = T
20    CONTINUE
      W(L) = P
30    IF ( S .EQ. 0. ) GOTO 120
      Y = V(P,L)
      V(P,L) = V(L,L)
C     -----------------------------
C     |*** COMPUTE MULTIPLIERS ***|
C     -----------------------------
      V(L,L) = -1.
      Y = 1./Y
      DO 40 I = 1,N
40         V(I,L) = -Y*V(I,L)
      J = L
50    J = J + 1
      IF ( J .GT. N ) J = 1
      IF ( J .EQ. L ) GOTO 10
      Z = V(P,J)
      V(P,J) = V(L,J)
      V(L,J) = Z
      IF ( CABS(Z) .EQ. 0. ) GOTO 50
C     ------------------------------
C     |*** ELIMINATE BY COLUMNS ***|
C     ------------------------------
      IF ( K .EQ. 0 ) GOTO 70
      DO 60 I = 1,K
60         V(I,J) = V(I,J) + Z*V(I,L)
70    V(L,J) = Y*Z
      IF ( M .GT. N ) GOTO 50
      DO 80 I = M,N
80         V(I,J) = V(I,J) + Z*V(I,L)
      GOTO 50
C     -----------------------
C     |*** PIVOT COLUMNS ***|
C     -----------------------
90    L = W(K)
      DO 100 I = 1,N
           Y = V(I,L)
           V(I,L) = V(I,K)
100        V(I,K) = Y
      K = K - 1
      IF ( K .GT. 0 ) GOTO 90
      RETURN
110   IF ( CABS(V(1,1)) .EQ. 0. ) GOTO 120
      V(1,1) = 1./V(1,1)
      RETURN
120   WRITE(6,*) 'ERROR: MATRIX HAS NO INVERSE'
      STOP
      END
