C
C      ________________________________________________________
C     |                                                        |
C     |  COMPUTE THE DIAGONALIZATION OF A GENERAL REAL MATRIX  |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         LV    --LEADING (ROW) DIMENSION OF ARRAY V     |
C     |                                                        |
C     |         A     --REAL ARRAY CONTAINING COEFFICIENT      |
C     |                 MATRIX (LENGTH AT LEAST N(N+7) - 2)    |
C     |                                                        |
C     |         LA    --LEADING (ROW) DIMENSION OF ARRAY A     |
C     |                                                        |
C     |         N     --DIMENSION OF MATRIX STORED IN A        |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --COMPLEX ARRAY OF EIGENVALUES           |
C     |                                                        |
C     |         V     --COMPLEX ARRAY OF EIGENVECTORS          |
C     |                                                        |
C     |    PACKAGE SUBROUTINES: AHESS,DAG,SIM                  |
C     |________________________________________________________|
C
      SUBROUTINE DIAG(E,V,LV,A,LA,N)
      COMPLEX E(1)
      REAL A(1),V(1)
      INTEGER I,J,K,L,LA,LV,M,N,O,P
      IF ( N .GT. 1 ) GOTO 10
      E(1) = A(1)
      V(1) = 1.
      RETURN
10    IF ( LV .GE. N ) GOTO 20
      WRITE(6,*) 'LV ARGUMENT IN SUB DIAG MUST BE .GE. N ARGUMENT'
      STOP
20    CALL AHESS(A,LA,N,E)
      CALL SIM(V,N,A)
      O = N + 1
      P = N + 2
      I = 1 + N*O
      J = N + N - 3
30    A(I+J) = A(I)
      I = I - 1
      IF ( I .GT. 0 ) GOTO 30
      J = 1
      K = N*P - O
      M = N + N
      L = M + 1
40    DO 50 I = M,L
           A(J) = A(I)
           A(J+1) = 0.
50         J = J + 2
      M = M + O
      L = L + P
      IF ( J .LT. K ) GOTO 40
      IF ( J .GT. K ) GOTO 60
      L = L - 1
      GOTO 40
60    I = N*N
      J = I + I
70    V(J) = 0.
      V(J-1) = V(I)
      I = I - 1
      J = J - 2
      IF ( I .GT. 0 ) GOTO 70
      I = K + N + N
      J = I + N + N
      K = J + N
      CALL DAG(E,V,N,A,N,A(K),A(J),A(I))
      K = 2*(LV-N)
      I = 2*N*N
      J = N*K - K
80    L = I - N - N
90    V(I+J) = V(I)
      I = I - 1
      IF ( I .GT. L ) GOTO 90
      J = J - K
      IF ( I .GT. 0 ) GOTO 80
      RETURN
      END
