C      ________________________________________________________
C     |                                                        |
C     | ESTIMATE 1-NORM CONDITION OF AN UPPER HESSENBERG MATRIX|
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --EFACT'S OUTPUT                         |
C     |                                                        |
C     |         B     --WORK ARRAY (LENGTH AT LEAST N)         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         ECON   --CONDITION NUMBER                      |
C     |                 (IF MATRIX IS SINGULAR, ECON = -1)     |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |    PACKAGE SUBROUTINES: ESOLVE,ETRANS                  |
C     |________________________________________________________|
C
      FUNCTION ECON(A,B)
      REAL A(1),B(1),C,D
      INTEGER I,J,M,N
      C = A(1)
      IF ( ABS(C) .EQ. 1237 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH EFACT BEFORE',
     1'ESTIMATING CONDITION'
      STOP
10    IF ( C .LT. 0. ) GOTO 110
      M = 0
      N = A(2)
      C = 1./A(2)
      DO 20 J = 1,N
20         B(J) = C
      GOTO 50
30    DO 40 J = 1,N
40         B(J) = 0.
      B(M) = 1.
50    CALL ESOLVE(B,A,B)
      C = 0.
      DO 70 J = 1,N
           C = C + ABS(B(J))
           IF ( B(J) .LT. 0. ) GOTO 60
           B(J) = 1.
           GOTO 70
60         B(J) = -1.
70    CONTINUE
      CALL ETRANS(B,A,B)
      I = 1
      DO 80 J = 1,N
80         IF ( ABS(B(I)) .LT. ABS(B(J)) ) I = J
      IF ( M .EQ. 0 ) GOTO 90
      IF ( M .EQ. I ) GOTO 100
      IF ( D .GE. C ) GOTO 100
90    M = I
      D = C
      GOTO 30
100   C = C*A(3)
      IF ( C .LT. 1. ) C = 1.
      ECON = C
      RETURN
110   ECON = -1.
      RETURN
      END
