C      ________________________________________________________
C     |                                                        |
C     | SOLVE A FACTORED SYMMETRIC BAND SYSTEM WITHOUT PIVOTING|
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --HFACT'S OUTPUT                         |
C     |                                                        |
C     |         B     --RIGHT SIDE                             |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         X     --SOLUTION (CAN BE IDENTIFIED WITH B     |
C     |                 ALTHOUGH THE RIGHT SIDE IS DESTROYED)  |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS,MIN0                         |
C     |________________________________________________________|
C
      SUBROUTINE HSOLVE(X,A,B)
      REAL A(1),B(1),X(1),T
      INTEGER H,I,J,K,L,M,N
      T = A(1)
      IF ( ABS(T) .EQ. 1232 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH HFACT BEFORE SOLVING'
      STOP
10    N = A(2)
      H = A(4)
      J = 4 - H
      K = 1
      IF ( T .LT. 0. ) GOTO 90
      DO 20 I = 1,N
20         X(I) = B(I)
      IF ( H .GT. 0 ) GOTO 40
C     ------------------------
C     |*** DIAGONAL MATRIX***|
C     ------------------------
      DO 30 K = 1,N
30         X(K) = X(K)/A(4+K)
      RETURN
C     -----------------------------
C     |*** FORWARD ELIMINATION ***|
C     -----------------------------
40    J = J + H
      IF ( K .EQ. N ) GOTO 60
      T = X(K)/A(J+K)
      L = MIN0(N,K+H)
      K = K + 1
      IF ( T .EQ. 0. ) GOTO 40
      DO 50 I = K,L
50         X(I) = X(I) - T*A(I+J)
      GOTO 40
C     -----------------------------------
C     |*** BACK SUBSTITUTION BY ROWS ***|
C     -----------------------------------
60    X(N) = X(N)/A(J+K)
70    IF ( K .EQ. 1 ) RETURN
      J = J - H
      M = K
      K = K - 1
      L = MIN0(N,K+H)
      T = X(K)
      DO 80 I = M,L
80         T = T - X(I)*A(I+J)
      X(K) = T/A(J+K)
      GOTO 70
C     -----------------------------
C     |*** COMPUTE NULL VECTOR ***|
C     -----------------------------
90    K = 0
100   K = K + 1
      J = J + H
      IF ( A(J+K) .NE. 0. ) GOTO 100
      DO 110 I = 1,N
110        X(I) = 0.
      X(K) = 1.
      IF ( H .EQ. 0 ) RETURN
      GOTO 70
      END
