C
C      ________________________________________________________
C     |                                                        |
C     |SOLVE  F SUB I (X) = 0, I = 1 TO N, USING A QUASI-NEWTON|
C     |              SCHEME (BROYDEN'S GOOD METHOD)            |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         X     --STARTING GUESS                         |
C     |                                                        |
C     |         H     --STARTING GUESS FOR INVERSE JACOBIAN    |
C     |                                                        |
C     |         LH    --LEADING (ROW) DIMENSION OF ARRAY H     |
C     |                                                        |
C     |         N     --NUMBER OF EQUATIONS                    |
C     |                                                        |
C     |         NDIGIT--DESIRED NUMBER CORRECT DIGITS          |
C     |                                                        |
C     |         LIMIT --MAXIMUM NUMBER OF ITERATIONS           |
C     |                                                        |
C     |         FUNC  --NAME OF FUNCTION EVALUATION SUBROUTINE |
C     |                 (EXTERNAL IN MAIN PROG.) FUNC(F,X) PUTS|
C     |                 IN ARRAY F THE FUNCTION VALUE AT X     |
C     |                                                        |
C     |         W     -WORK ARRAY (LENGTH AT LEAST 3N)         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         X     --SOLUTION                               |
C     |                                                        |
C     |         DIF   --INPUT FOR SUBROUTINE WHATIS            |
C     |                                                        |
C     |         SIZE  --INPUT FOR SUBROUTINE WHATIS            |
C     |                                                        |
C     |    PACKAGE SUBROUTINES: ADDCHG,STOPIT                  |
C     |________________________________________________________|
C
      SUBROUTINE QUASI(X,H,LH,N,DIF,SIZE,NDIGIT,LIMIT,FUNC,W)
      INTEGER I,J,LH,LIMIT,N,NDIGIT
      REAL H(LH,1),W(N,1),X(1),S,T,U,DIF,SIZE
      DO 10 I = 1,N
           W(I,1) = 0.
10    CONTINUE
      GOTO 30
C     --------------------
C     |*** ADD S TO X ***|
C     --------------------
20    CALL ADDCHG(DIF,SIZE,X,W,N)
      CALL STOPIT(DIF,SIZE,NDIGIT,LIMIT)
      IF ( DIF .LE. 0. ) RETURN
C     -----------------
C     |*** FORM  U ***|
C     -----------------
30    DO 40 I = 1,N
           W(I,2) = W(I,1)
           W(I,1) = 0.
40    CONTINUE
      CALL FUNC(W(1,3),X)
      DO 60 J = 1,N
           T = W(J,3)
           DO 50 I = 1,N
                W(I,1) = W(I,1) - T*H(I,J)
50         CONTINUE
60    CONTINUE
C     -----------------------------------
C     |*** FORM  S DOT S AND S DOT U ***|
C     -----------------------------------
      T = 0.
      U = 0.
      DO 70 I = 1,N
           S = W(I,2)
           T = T + S*W(I,1)
           U = U + S*S
70    CONTINUE
      T = U - T
      IF ( T .EQ. 0. ) GOTO 20
C     ------------------
C     |*** UPDATE H ***|
C     ------------------
      DO 100 J = 1,N
           S = 0.
           DO 80 I = 1,N
                S = S + H(I,J)*W(I,2)
80         CONTINUE
           S = S/T
           DO 90 I = 1,N
                H(I,J) = H(I,J) + S*W(I,1)
90       CONTINUE
100   CONTINUE
      U = U/T
      DO 110 I = 1,N
           W(I,1) = U*W(I,1)
110   CONTINUE
      GOTO 20
      END
