C
C      ________________________________________________________
C     |                                                        |
C     | GIVEN THE SINGULAR VALUE DECOMPOSITION QDP TRANSPOSE OF|
C     | A GENERAL MATRIX A, COMPUTE THE REGULARIZED SOLUTION TO|
C     |                        AX = B                          |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         B     --RIGHT SIDE                             |
C     |                                                        |
C     |         Q     --FIRST FACTOR IN THE SVD DECOMPOSITION  |
C     |                                                        |
C     |         LQ    --LEADING (ROW) DIMENSION OF ARRAY Q     |
C     |                                                        |
C     |         MQ    --NUMBER OF ROWS FOR MATRIX STORED IN Q  |
C     |                                                        |
C     |         D     --SINGULAR VALUES                        |
C     |                                                        |
C     |         P     --LAST FACTOR IN THE SVD DECOMPOSITION   |
C     |                                                        |
C     |         LP    --LEADING (ROW) DIMENSION OF ARRAY P     |
C     |                                                        |
C     |         MP    --NUMBER OF ROWS FOR MATRIX STORED IN P  |
C     |                                                        |
C     |         R     --REGULARIZATION PARAMETER               |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         X     --THE REGULARIZED SOLUTION               |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS,MIN0,SQRT                    |
C     |________________________________________________________|
C
      SUBROUTINE RSOLVE(X,B,Q,LQ,MQ,D,P,LP,MP,R)
      INTEGER I,J,LP,LQ,MP,MQ,N
      REAL B(1),D(1),Q(LQ,1),P(LP,1),X(1),R,T,Y,Z
      N = MIN0(MQ,MP)
      Z = ABS(R)
      Y = SQRT(Z)
      DO 10 I = 1,MP
10         X(I) = 0.
      DO 60 J = 1,N
           IF ( D(J) .EQ. 0. ) GOTO 60
           T = 0.
           DO 20 I = 1,MQ
20              T = T + Q(I,J)*B(I)
           IF ( D(J) .GT. Y ) GOTO 30
           T = T*(D(J)/(D(J)**2+Z))
           GOTO 40
30         T = T/(D(J)+Z/D(J))
40         DO 50 I = 1,MP
50              X(I) = X(I) + T*P(I,J)
60    CONTINUE
      RETURN
      END
