C
C      ________________________________________________________
C     |                                                        |
C     |                 TEST FOR CONVERGENCE                   |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         DIF   --ABSOLUTE DIFFERENCE                    |
C     |                                                        |
C     |         SIZE  --ABSOLUTE VALUE                         |
C     |                                                        |
C     |         NDIGIT--DESIRED NUMBER CORRECT DIGITS          |
C     |                                                        |
C     |         LIMIT --MAXIMUM NUMBER ITERATIONS              |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         DIF   --POSITIVE TO CONTINUE ITERATIONS        |
C     |                                                        |
C     |         SIZE  --ABSOLUTE DIFFERENCE                    |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |________________________________________________________|
C
      SUBROUTINE STOPIT(DIF,SIZE,NDIGIT,LIMIT)
      REAL DIF,SIZE,E,T
      INTEGER I,LIMIT,NDIGIT
      DATA I/0/
      DIF = ABS(DIF)
      SIZE = ABS(SIZE)
C     -----------------------------------------------
C     |*** INITIALIZATION DURING FIRST ITERATION ***|
C     -----------------------------------------------
      IF ( I .GT. 0 ) GOTO 10
      T = 10.**(-NDIGIT)
C     ------------------------------
C     |*** STOPPING CRITERION I ***|
C     ------------------------------
10    I = I + 1
      E = 3*I
      IF ( DIF .GT. T*SIZE ) GOTO 20
      E = E + 1.
      GOTO 30
C     -------------------------------
C     |*** STOPPING CRITERION II ***|
C     -------------------------------
20    IF ( I .LT. LIMIT ) GOTO 40
      E = E + 2.
30    DIF = -DIF
      I = 0
40    SIZE = E
      RETURN
      END
