C
C      ________________________________________________________
C     |                                                        |
C     |      FACTOR A TRIDIAGONAL MATRIX WITHOUT PIVOTING      |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         L     --SUBDIAGONAL (CAN BE IDENTIFIED WITH U  |
C     |                 IF THE COEFFICIENT MATRIX IS SYMMETRIC)|
C     |                                                        |
C     |         D     --DIAGONAL (LENGTH AT LEAST 3 + N)       |
C     |                                                        |
C     |         U     --SUPERDIAGONAL                          |
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         L,D,U --BANDS OF FACTORED MATRIX               |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |________________________________________________________|
C
      SUBROUTINE TFACT(L,D,U,N)
      REAL D(1),L(1),U(1),R,S,T,W,X,Y
      INTEGER I,J,K,M,N
      I = 4 + N
      J = 1 + N
      DO 10 K = 1,N
10         D(I-K) = D(J-K)
      X = 1234
      T = U(1)
      S = L(1)
      U(1) = 0.
      L(1) = 1.
      IF ( U(1) .EQ. 1. ) X = 1238
      U(1) = T
      L(1) = S
      D(1) = X
      D(2) = N
      R = 0.
      S = 0.
      W = D(4)
      T = W
      IF ( N .EQ. 1 ) GOTO 40
      M = N - 1
      DO 30 K = 1,M
           R = R + ABS(L(K)) + ABS(W)
           IF ( R .GT. S ) S = R
           R = ABS(U(K))
           J = K + 4
           W = D(J)
           IF ( T .NE. 0. ) GOTO 20
           D(1) = -X
           T = W
           GOTO 30
20         Y = L(K)/T
           T = W - Y*U(K)
           L(K) = Y
           D(J) = T
30    CONTINUE
40    R = R + ABS(W)
      IF ( R .GT. S ) S = R
      D(3) = S
      IF ( T .EQ. 0. ) D(1) = -X
      RETURN
      END
