#include <stdio.h>

long f1(void);
long f2(long bpl);
double f3(void);
void f4(double *p);



long DoublePrecision()
{
   long k;
   long i;
   double l1 = (double)1;
   double lh = 1/(double)2;
   double epsilon;
   double fudge, oldfudge;

   epsilon = l1;
   fudge = l1+l1;

   k = 0;

   do {
      k++;
      epsilon = epsilon * lh;
      oldfudge = fudge;
      fudge = l1 + epsilon;
      f4(&fudge);
      f4(&oldfudge);
   } while (fudge > l1 && fudge < oldfudge);

   return k;
}

union d_or_rep {
   double d;
   unsigned long rep[2];
};

long RepTest(void)
{
   union d_or_rep v;

   v.rep[0] = v.rep[1] = 0;

   v.d = 565656565656.0;

   if (v.rep[0] == 0x42607678 && v.rep[1] == 0x46f30000)
      return 1;
   else if (v.rep[1] == 0x42607678 && v.rep[0] == 0x46f30000)
      return -1;
   else
      return 0;
}

void print2k(FILE *f, long k, long bpl)
{
   long m, l;
   long first;

   if (k <= 0) {
      fprintf(f, "((double) 1.0)");
      return;
   }

   m = bpl - 2;
   first = 1;

   fprintf(f, "(");

   while (k > 0) {
      if (k > m)
         l = m;
      else
         l = k;

      k = k - l;

      if (first)
         first = 0;
      else 
         fprintf(f, "*");

      fprintf(f, "((double)(1L<<%d))", l);
   }

   fprintf(f, ")");
}
   

   


   


char *yn_vec[2] = { "no", "yes" }; 


main()
{
   long bpl, rs_arith, nbits, single_mul_ok;
   long a;
   long x;
   long dp;
   FILE *f;

   x = f1();
   if (~x != 0) {
      fprintf(stderr, "BAD NEWS: machine must be 2's compliment.\n");
      return 1;
   }

   if ((x >> 1) == x)
      rs_arith = 1;
   else
      rs_arith = 0;

   bpl = 0;
   while (x != 0) {
      x = x << 1;
      bpl++;
   }

   a = f2(bpl);
   if (2*a != -2 || a*a != 1) {
      fprintf(stderr, "BAD NEWS: machine must work modulo 2^wordsize.\n");
      return 1;
   }

   if (((long)f3()) != 1.0) {
      fprintf(stderr, "BAD NEWS: machine must truncate floating point.\n");
      return 1;
   }


   dp = DoublePrecision();

   if (bpl-2 < dp-3)
      nbits = bpl-2;
   else
      nbits = dp-3;

   if (nbits & 1) nbits--;

   if (nbits < 10) {
      fprintf(stderr, "BAD NEWS: NBITS too small.\n");
      return 1;
   }

   single_mul_ok = RepTest();

   fprintf(stderr, "GOOD NEWS: compatible machine.\n");
   fprintf(stderr, "summary of machine characteristics:\n");
   fprintf(stderr, "bits per long = %d\n", bpl);
   fprintf(stderr, "arith right shift = %s\n", yn_vec[rs_arith]);
   fprintf(stderr, "double precision = % d\n", dp);
   fprintf(stderr, "NBITS = %d\n", nbits);
   fprintf(stderr, "single mul ok = %s\n", yn_vec[single_mul_ok != 0]);

#if (defined(__sparc__) && !defined(__sparc_v8__))

   fprintf(stderr, "\n\nIMPORTANT:\n\n");
   fprintf(stderr, "If this Sparc is a Sparc-10 or later (so it has\n");
   fprintf(stderr, "a hardware integer multiply instruction) you\n");
   fprintf(stderr, "should use the -mv8 option to obtain more\n");
   fprintf(stderr, "efficient code.\n\n");

#endif

   f = fopen("mach_desc.h", "w");
   if (!f) {
      fprintf(stderr, "can't open mach_desc.h for writing\n");
      return 1;
   }

   fprintf(f, "#ifndef mach_desc__H\n");
   fprintf(f, "#define mach_desc__H\n\n\n");
   fprintf(f, "#define ZZ_BITS_PER_LONG (%d)\n", bpl);
   fprintf(f, "#define ZZ_ARITH_RIGHT_SHIFT (%d)\n", rs_arith);
   fprintf(f, "#define ZZ_NBITS (%d)\n", nbits);
   fprintf(f, "#define ZZ_DOUBLE_PRECISION (%d)\n", dp);
   fprintf(f, "#define ZZ_FDOUBLE_PRECISION ");
   print2k(f, dp-1, bpl);
   fprintf(f, "\n");
   fprintf(f, "#define ZZ_SINGLE_MUL_OK (%d)\n", single_mul_ok != 0);
   fprintf(f, "#define ZZ_DOUBLES_LOW_HIGH (%d)\n\n\n", single_mul_ok < 0);
   fprintf(f, "#endif\n\n");

   fclose(f);
   
   return 0;
}
