#ifndef ZZXFactoring__H
#define ZZXFactoring__H


#include "ZZX.h"
#include "pair_ZZX_long.h"

void mul(ZZX& x, vector(pair(ZZX,long))& a);

void SquareFreeDecomp(vector(pair(ZZX,long))& u, const ZZX& f);
// input is primitive, with positive leading coefficient

void MultiLift(vector(ZZX)& A, const vector(zz_pX)& a, const ZZX& f, long e,
               long verbose=0);

// Using current value p of zz_p::modulus(), this lifts
// the square-free factorization a mod p of f to a factorization
// A mod p^e of f.
// It is required that f and all the polynomials in a are monic.



void SFFactor(vector(ZZX)& factors, const ZZX& f,
              long verbose=0,
              long bnd=0);

// input f is primitive and square-free, with positive leading
// coefficient.  

// bnd, if not zero, indicates that
// f divides a polynomial h whose Euclidean norm
// is bounded by 2^{bnd} in absolute value.


void factor(ZZ& c,
            vector(pair(ZZX,long))& factors,
            const ZZX& f,
            long verbose=0,
            long bnd=0);

// input f is is an arbitrary polynomial.
// c is the content of f, and factors is the facrorization
// of its primitive part.

// bnd is as in SFFactor.


#endif
