

#ifndef ZZ_pXFactoring__H
#define ZZ_pXFactoring__H

#include "ZZ.h"
#include "ZZ_p.h"
#include "ZZ_pX.h"
#include "pair_ZZ_pX_long.h"




/************************************************************

                      factorization routines 

************************************************************/





void SquareFreeDecomp(vector(pair(ZZ_pX,long))& u, const ZZ_pX& f);

// Performs square-free decomposition.
// f must be monic.
// If f = prod_i g_i^i, then u is set to a lest of pairs (g_i, i).
// The list is is increasing order of i, with trivial terms 
// (i.e., g_i = 1) deleted.


void FindRoots(vector(ZZ_p)& x, const ZZ_pX& f);

// f is monic, and has deg(f) distinct roots.
// returns the list of roots

void FindRoot(ZZ_p& root, const ZZ_pX& f);

// finds a single root of f.
// assumes that f is monic and splits into distinct linear factors


void SFBerlekamp(vector(ZZ_pX)& factors, const ZZ_pX& f, long verbose=0);

// Assumes f is square-free and monic.
// returns list of factors of f.
// Uses "Berlekamp" appraoch.


void berlekamp(vector(pair(ZZ_pX,long))& factors, const ZZ_pX& f, long verbose=0);

// returns a list of factors, with multiplicities.
// f must be monic.
// Uses "Berlekamp" appraoch.


extern long ZZ_pX_BlockingFactor;
// Controls GCD blocking for DDF.

void DDF(vector(pair(ZZ_pX,long))& factors, const ZZ_pX& f, const ZZ_pX& h,
         long verbose=0);

// Performs distinct-degree factorization.
// Assumes f is monic and square-free,  and h  = X^p mod f
// Obsolete: see NewDDF, below.

extern long ZZ_pX_GCDTableSize; /* = 4 */
// Controls GCD blocking for NewDDF

extern char ZZ_pX_stem[]; 
// Determines filename stem for external storage in NewDDF.

void NewDDF(vector(pair(ZZ_pX,long))& factors, const ZZ_pX& f, const ZZ_pX& h,
         long verbose=0);

// same as above, but uses baby-step/giant-step method


void EDF(vector(ZZ_pX)& factors, const ZZ_pX& f, const ZZ_pX& b,
         long d, long verbose=0);

// Performs equal-degree factorization.
// f is monic, square-free, and all irreducible factors have same degree.
// b = X^p mod f.
// d = degree of irreducible factors of f
// Space for the trace-map computation can be controlled via ComposeBound.



void RootEDF(vector(ZZ_pX)& factors, const ZZ_pX& f, long verbose=0);

// EDF for d==1

void SFCanZass(vector(ZZ_pX)& factors, const ZZ_pX& f, long verbose=0);

// Assumes f is monic and square-free.
// returns list of factors of f.
// Uses "Cantor/Zassenhaus" approach.



void CanZass(vector(pair(ZZ_pX,long))& factors, const ZZ_pX& f, long verbose=0);

// returns a list of factors, with multiplicities.
// f must be monic.
// Uses "Cantor/Zassenhaus" approach.


void mul(ZZ_pX& f, const vector(pair(ZZ_pX,long))& v);

// multiplies polynomials, with multiplicities


/*************************************************************

            irreducible poly's:  tests and constructions

**************************************************************/

long ProbIrredTest(const ZZ_pX& f, long iter=1);

// performs a fast, probabilistic irreduciblity test
// the test can err only if f is reducible, and the
// error probability is bounded by p^{-iter}.

long DetIrredTest(const ZZ_pX& f);

// performs a recursive deterministic irreducibility test
// fast in the worst-case (when input is irreducible).

long IterIrredTest(const ZZ_pX& f);

// performs an iterative deterministic irreducibility test,
// based on DDF.  Fast on average (when f has a small factor).

void BuildIrred(ZZ_pX& f, long n);

// Build a monic irreducible poly of degree n.

void BuildRandomIrred(ZZ_pX& f, const ZZ_pX& g);

// g is a monic irreducible polynomial.
// constructs a random monic irreducible polynomial f of the same degree.


long ComputeDegree(const ZZ_pX& h, const ZZ_pXModulus& F);

// f = F.f is assumed to be an "equal degree" polynomial
// h = X^p mod f
// the common degree of the irreducible factors of f is computed
// This routine is useful in counting points on elliptic curves

long ProbComputeDegree(const ZZ_pX& h, const ZZ_pXModulus& F);

// same as above, but uses a slightly faster probabilistic algorithm
// the return value may be 0 or may be too big, but for large p
// (relative to n), this happens with very low probability.



void TraceMap(ZZ_pX& w, const ZZ_pX& a, long d, const ZZ_pXModulus& F,
              const ZZ_pX& b);

// w = a+a^q+...+^{q^{d-1}} mod f;
// it is assumed that d >= 0, and b = X^q mod f, q a power of p
// Space allocation can be controlled via ComposeBound (see "ZZ_pX.h")



void PowerCompose(ZZ_pX& w, const ZZ_pX& a, long d, const ZZ_pXModulus& F);

// w = X^{q^d} mod f;
// it is assumed that d >= 0, and b = X^q mod f, q a power of p
// Space allocation can be controlled via ComposeBound (see "ZZ_pX.h")


#endif
