
#ifndef mat_ZZ__H
#define mat_ZZ__H

#include "matrix.h"
#include "vec_vec_ZZ.h"

#include "mat_zz_p.h"
#include "mat_ZZ_p.h"

matrix_decl(ZZ)
matrix_io_decl(ZZ)
matrix_eq_decl(ZZ)


void add(matrix(ZZ)& X, const matrix(ZZ)& A, const matrix(ZZ)& B); 
void sub(matrix(ZZ)& X, const matrix(ZZ)& A, const matrix(ZZ)& B); 
void mul(matrix(ZZ)& X, const matrix(ZZ)& A, const matrix(ZZ)& B); 
void mul(vector(ZZ)& x, const matrix(ZZ)& A, const vector(ZZ)& b); 
void mul(vector(ZZ)& x, const vector(ZZ)& a, const matrix(ZZ)& B); 
void mul(matrix(ZZ)& X, const matrix(ZZ)& A, const ZZ& b);
void ident(matrix(ZZ)& X, long n); 
long IsIdent(const matrix(ZZ)& A, long n);
void diag(matrix(ZZ)& X, long n, const ZZ& d);
long IsDiag(const matrix(ZZ)& A, long n, const ZZ& d);

void determinant(ZZ& d, const matrix(ZZ)& A, long deterministic=0);
void solve(ZZ& d, vector(ZZ)& x,
           const matrix(ZZ)& A, const vector(ZZ)& b,
           long deterministic=0);

void inv(ZZ& d, matrix(ZZ)& X, const matrix(ZZ)& A, long deterministic=0);



void transpose(matrix(ZZ)& X, const matrix(ZZ)& A);


void operator<<(matrix(zz_p)& x, const matrix(ZZ)& a);
void operator<<(matrix(ZZ_p)& x, const matrix(ZZ)& a);
long CRT(matrix(ZZ)& g, ZZ& a, const matrix(zz_p)& G);


#endif
