

/***********************************************************************

   This software is for research and educational purposes only.

************************************************************************/



#include "vec_zz_p.h"
#include <malloc.h>
#include "tools.h"


vector_impl(zz_p)

vector_io_impl(zz_p)

vector_eq_impl(zz_p)

void operator<<(vector(ZZ)& x, const vector(zz_p)& a)
{
   long i, n;

   n = a.length();
   x.SetLength(n);

   ZZ* xp = x.elts();
   const zz_p* ap = a.elts();

   for (i = 0; i < n; i++)
      xp[i] << rep(ap[i]);
}

void operator<<(vector(zz_p)& x, const vector(ZZ)& a)
{
   long i, n;

   n = a.length();
   x.SetLength(n);

   zz_p* xp = x.elts();
   const ZZ* ap = a.elts();

   for (i = 0; i < n; i++)
      xp[i] << ap[i];
}





void InnerProduct(zz_p& x, const vector(zz_p)& a, const vector(zz_p)& b)
{
   long n = min(a.length(), b.length());
   long i;
   zz_p accum, t;

   clear(accum);
   for (i = 0; i < n; i++) {
      mul(t, a[i], b[i]);
      add(accum, accum, t);
   }

   x = accum;
}

void InnerProduct(zz_p& x, const vector(zz_p)& a, const vector(zz_p)& b,
                  long offset)
{
   long n = min(a.length(), b.length()+offset);
   long i;
   zz_p accum, t;

   clear(accum);
   for (i = offset; i < n; i++) {
      mul(t, a[i], b[i-offset]);
      add(accum, accum, t);
   }

   x = accum;
}


long CRT(vector(ZZ)& g, ZZ& a, const vector(zz_p)& G)
{
   long n = g.length();
   if (G.length() != n) Error("CRT: vector length mismatch");

   long p = zz_p::modulus();
   zz_p a_inv;

   a_inv << a;
   inv(a_inv, a_inv);
 
   ZZ aa, new_a, new_a1;
   ZZ v_a, v_p, t;

   mul(aa, a, rep(a_inv));
   mul(new_a, a, p);

   RightShift(new_a1, new_a, 1);

   long modified = 0;
   long i;

   for (i = 0; i < n; i++) {
      zz_p k;
      k << g[i];
      mul(k, k, a_inv);
      negate(k, k);
      mul(v_a, a, rep(k));
      add(v_a, v_a, g[i]);

      mul(v_p, aa, rep(G[i]));
      add(t, v_a, v_p);

      rem(t, t, new_a);
      if (t > new_a1)
         sub(t, t, new_a);

      if (t != g[i]) {
         g[i] = t;
         modified = 1;
      }
   }

   a = new_a;

   return modified;
}

void mul(vector(zz_p)& x, const vector(zz_p)& a, zz_p b)
{
   long n = a.length();
   x.SetLength(n);
   long i;
   for (i = 0; i < n; i++)
      mul(x[i], a[i], b);
}

void add(vector(zz_p)& x, const vector(zz_p)& a, const vector(zz_p)& b)
{
   long n = a.length();
   if (b.length() != n) Error("vector add: dimension mismatch");

   x.SetLength(n);
   long i;
   for (i = 0; i < n; i++)
      add(x[i], a[i], b[i]);
}

void sub(vector(zz_p)& x, const vector(zz_p)& a, const vector(zz_p)& b)
{
   long n = a.length();
   if (b.length() != n) Error("vector sub: dimension mismatch");
   x.SetLength(n);
   long i;
   for (i = 0; i < n; i++)
      sub(x[i], a[i], b[i]);
}

void clear(vector(zz_p)& x)
{
   long n = x.length();
   long i;
   for (i = 0; i < n; i++)
      clear(x[i]);
}

void negate(vector(zz_p)& x, const vector(zz_p)& a)
{
   long n = a.length();
   x.SetLength(n);
   long i;
   for (i = 0; i < n; i++)
      negate(x[i], a[i]);
}

